/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.utils;

import de.fraunhofer.iosb.ilt.frostclient.SensorThingsService;
import de.fraunhofer.iosb.ilt.frostclient.exception.ServiceFailureException;
import de.fraunhofer.iosb.ilt.frostclient.model.Entity;
import de.fraunhofer.iosb.ilt.frostclient.models.ext.UnitOfMeasurement;
import de.fraunhofer.iosb.ilt.frostclient.utils.EntityCacheDynamic;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FrostUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FrostUtils.class);
    private static final int DEFAULT_MAX_PROPERTIES_DEPTH = 5;
    public static final ZoneId ZONE_ID_Z = ZoneId.of("Z");
    public static final UnitOfMeasurement NULL_UNIT = new UnitOfMeasurement(null, null, null);
    public static final String ENCODING_GEOJSON = "application/geo+json";
    public static final String CONTENT_TYPE_GEOJSON = "application/geo+json";
    private final SensorThingsService service;
    private boolean dryRun;
    private int countInsert;
    private int countUpdate;
    private String logPrefix = "";

    public FrostUtils(SensorThingsService service) {
        this.service = service;
    }

    public FrostUtils setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public FrostUtils setLogPrefix(String logPrefix) {
        this.logPrefix = logPrefix;
        return this;
    }

    public SensorThingsService getService() {
        return this.service;
    }

    public void update(Entity entity) throws ServiceFailureException {
        if (this.dryRun) {
            LOGGER.info("{}Dry Run: Not updating entity {}", (Object)this.logPrefix, (Object)entity);
        } else {
            this.service.update(entity);
            ++this.countUpdate;
        }
    }

    public void create(Entity entity) throws ServiceFailureException {
        if (this.dryRun) {
            LOGGER.info("{}Dry Run: Not creating entity {}", (Object)this.logPrefix, (Object)entity);
        } else {
            this.service.create(entity);
            ++this.countInsert;
        }
    }

    public int getCountInsert() {
        return this.countInsert;
    }

    public int getCountUpdate() {
        return this.countUpdate;
    }

    public FrostUtils resetCounts() {
        this.countInsert = 0;
        this.countUpdate = 0;
        return this;
    }

    public Entity findOrCreate(Entity newEntity, EntityCacheDynamic cache) throws ServiceFailureException {
        Entity cachedEntity = cache.getOrLoad(newEntity);
        if (cachedEntity == null) {
            this.create(newEntity);
            cache.put(newEntity);
            LOGGER.info("{}Created {}: {}", new Object[]{this.logPrefix, newEntity.getEntityType(), cache.localIdFor(newEntity)});
            return newEntity;
        }
        return cachedEntity;
    }

    public static boolean addProperties(Map<String, Object> target, Map<String, Object> source, int maxDepth) {
        if (target == null) {
            return false;
        }
        boolean updated = false;
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if ((value == null || String.valueOf(value).isEmpty()) && !target.containsKey(key)) continue;
            if (!target.containsKey(key)) {
                target.put(key, value);
                updated = true;
                continue;
            }
            Object tValue = target.get(key);
            if (value instanceof Map) {
                Map valueMap = (Map)value;
                if (maxDepth <= 0) continue;
                if (tValue instanceof Map) {
                    Map tValueMap = (Map)tValue;
                    updated = updated || FrostUtils.addProperties(tValueMap, valueMap, maxDepth - 1);
                    continue;
                }
                target.put(key, value);
                updated = true;
                continue;
            }
            if (FrostUtils.resultCompare(value, tValue)) continue;
            target.put(key, value);
            updated = true;
        }
        return updated;
    }

    private static boolean resultCompare(Object one, Object two) {
        if (one == null) {
            return two == null;
        }
        if (two == null) {
            return false;
        }
        if (one.equals(two)) {
            return true;
        }
        try {
            if (one instanceof Long) {
                Long longOne = (Long)one;
                if (two instanceof Integer) {
                    Integer intTwo = (Integer)two;
                    return longOne.equals(intTwo);
                }
            }
            if (two instanceof Long) {
                Long longTwo = (Long)two;
                if (one instanceof Integer) {
                    Integer intOne = (Integer)one;
                    return longTwo.equals(intOne);
                }
            }
            if (one instanceof BigDecimal) {
                BigDecimal decOne = (BigDecimal)one;
                return decOne.compareTo(new BigDecimal(two.toString())) == 0;
            }
            if (two instanceof BigDecimal) {
                BigDecimal decTwo = (BigDecimal)two;
                return decTwo.compareTo(new BigDecimal(one.toString())) == 0;
            }
            if (one instanceof BigInteger) {
                BigInteger bigIntOne = (BigInteger)one;
                return bigIntOne.equals(new BigInteger(two.toString()));
            }
            if (two instanceof BigInteger) {
                BigInteger bigIntTwo = (BigInteger)two;
                return bigIntTwo.equals(new BigInteger(one.toString()));
            }
            if (one instanceof Collection) {
                Collection cOne = (Collection)one;
                if (two instanceof Collection) {
                    Collection cTwo = (Collection)two;
                    Iterator iTwo = cTwo.iterator();
                    for (Object itemOne : cOne) {
                        if (iTwo.hasNext() && FrostUtils.resultCompare(itemOne, iTwo.next())) continue;
                        return false;
                    }
                    return !iTwo.hasNext();
                }
            }
        }
        catch (NumberFormatException exc) {
            LOGGER.trace("Not both bigdecimal.", (Throwable)exc);
        }
        return false;
    }
}

