/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.utils;

import de.fraunhofer.iosb.ilt.frostclient.dao.Dao;
import de.fraunhofer.iosb.ilt.frostclient.exception.ServiceFailureException;
import de.fraunhofer.iosb.ilt.frostclient.model.Entity;
import de.fraunhofer.iosb.ilt.frostclient.model.EntitySet;
import de.fraunhofer.iosb.ilt.frostclient.model.EntityType;
import de.fraunhofer.iosb.ilt.frostclient.query.Query;
import de.fraunhofer.iosb.ilt.frostclient.utils.PropertyExtractor;
import de.fraunhofer.iosb.ilt.frostclient.utils.StringHelper;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityCacheDynamic<U> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)EntityCacheDynamic.class.getName());
    private final Map<U, Entity> entitiesByLocalId = new LinkedHashMap<U, Entity>();
    private PropertyExtractor<U, Entity> localIdExtractor;
    private PropertyExtractor<String, U> filterFromlocalId;
    private String expand;
    private int maxSize = Integer.MAX_VALUE;
    private final EntityType entityType;
    private Dao dao;
    private DuplicateRule duplicateRule = DuplicateRule.ERROR;

    public EntityCacheDynamic(Dao dao) {
        this.dao = dao;
        this.entityType = dao.getEntityType();
    }

    public Entity get(U localId) {
        return this.entitiesByLocalId.get(localId);
    }

    public Entity get(Entity nonCached) {
        U localId = this.localIdExtractor.extractFrom(nonCached);
        return this.entitiesByLocalId.get(localId);
    }

    public Entity getOrLoad(Entity nonCached) throws ServiceFailureException {
        U localId = this.localIdExtractor.extractFrom(nonCached);
        return this.getOrLoad(localId);
    }

    public Entity getOrLoad(U localId) throws ServiceFailureException {
        Entity entity = this.entitiesByLocalId.get(localId);
        if (entity != null) {
            return entity;
        }
        if (this.filterFromlocalId != null) {
            List<Entity> entities;
            String filter = this.filterFromlocalId.extractFrom(localId);
            Query query = this.dao.query().filter(filter).top(2);
            if (!StringHelper.isNullOrEmpty(this.expand)) {
                query = query.expand(this.expand);
            }
            if ((entities = query.list().toList()).size() > 1) {
                if (this.duplicateRule == DuplicateRule.ERROR) {
                    throw new IllegalStateException("More than one " + this.entityType.entityName + " matches filter " + filter);
                }
                if (this.duplicateRule == DuplicateRule.WARN) {
                    LOGGER.warn("More than one {} matches filter {}", (Object)this.entityType.entityName, (Object)filter);
                }
            }
            if (!entities.isEmpty()) {
                entity = entities.get(0);
            }
            if (entity != null) {
                this.put(localId, entity);
            }
        }
        return entity;
    }

    public boolean containsId(U localId) {
        return this.entitiesByLocalId.containsKey(localId);
    }

    public void put(Entity entity) {
        U localId = this.localIdExtractor.extractFrom(entity);
        this.put(localId, entity);
    }

    public void put(U localId, Entity entity) {
        if (this.entitiesByLocalId.size() >= this.maxSize) {
            this.clear();
        }
        this.entitiesByLocalId.put(localId, entity);
    }

    public void clear() {
        this.entitiesByLocalId.clear();
    }

    public boolean isEmpty() {
        return this.entitiesByLocalId.isEmpty();
    }

    public int load() throws ServiceFailureException {
        return this.load(null);
    }

    public int load(String filter) throws ServiceFailureException {
        return this.load(filter, null, null);
    }

    public int load(String filter, String select, String expand) throws ServiceFailureException {
        Query query = this.dao.query();
        if (!StringHelper.isNullOrEmpty(select)) {
            query.select(select);
        }
        if (!StringHelper.isNullOrEmpty(expand)) {
            query.expand(expand);
        }
        if (!StringHelper.isNullOrEmpty(filter)) {
            query.filter(filter);
        }
        EntitySet entities = query.top(1000).orderBy("id asc").list();
        Iterator<Entity> iterator = entities.iterator();
        int count = 0;
        while (iterator.hasNext() && count < this.maxSize) {
            Entity entity = iterator.next();
            try {
                U localId = this.localIdExtractor.extractFrom(entity);
                if (localId == null) continue;
                this.entitiesByLocalId.put(localId, entity);
                ++count;
            }
            catch (RuntimeException ex) {
                LOGGER.debug("Failed to extract localId", (Throwable)ex);
            }
        }
        return count;
    }

    public int size() {
        return this.entitiesByLocalId.size();
    }

    public Collection<Entity> values() {
        return this.entitiesByLocalId.values();
    }

    public U localIdFor(Entity entity) {
        return this.localIdExtractor.extractFrom(entity);
    }

    public String localIdFilterFor(U localId) {
        return this.filterFromlocalId.extractFrom(localId);
    }

    public String localIdFilterFor(Entity entity) {
        return this.filterFromlocalId.extractFrom(this.localIdExtractor.extractFrom(entity));
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public EntityCacheDynamic<U> setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public Dao getDao() {
        return this.dao;
    }

    public EntityCacheDynamic<U> setDao(Dao dao) {
        this.dao = dao;
        return this;
    }

    public PropertyExtractor<U, Entity> getLocalIdExtractor() {
        return this.localIdExtractor;
    }

    public EntityCacheDynamic<U> setLocalIdExtractor(PropertyExtractor<U, Entity> localIdExtractor) {
        this.localIdExtractor = localIdExtractor;
        return this;
    }

    public PropertyExtractor<String, U> getFilterFromlocalId() {
        return this.filterFromlocalId;
    }

    public EntityCacheDynamic<U> setFilterFromlocalId(PropertyExtractor<String, U> filterFromlocalId) {
        this.filterFromlocalId = filterFromlocalId;
        return this;
    }

    public String getExpand() {
        return this.expand;
    }

    public EntityCacheDynamic<U> setExpand(String expand) {
        this.expand = expand;
        return this;
    }

    public DuplicateRule getDuplicateRule() {
        return this.duplicateRule;
    }

    public EntityCacheDynamic<U> setDuplicateRule(DuplicateRule duplicateRule) {
        this.duplicateRule = duplicateRule;
        return this;
    }

    public static enum DuplicateRule {
        ERROR,
        WARN,
        IGNORE;

    }
}

