/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.query;

import de.fraunhofer.iosb.ilt.frostclient.model.EntityType;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationProperty;
import de.fraunhofer.iosb.ilt.frostclient.query.QueryParameter;
import de.fraunhofer.iosb.ilt.frostclient.utils.StringHelper;
import java.util.ArrayList;
import java.util.List;

public class Expand {
    private EntityType onType;
    private final List<ExpandItem> items = new ArrayList<ExpandItem>();

    public EntityType getOnType() {
        return this.onType;
    }

    public Expand setOnType(EntityType onType) {
        this.onType = onType;
        return this;
    }

    public List<ExpandItem> getItems() {
        return this.items;
    }

    public ExpandItem getOrCreateItemFor(NavigationProperty navProp) {
        for (ExpandItem item : this.items) {
            if (item.navProp != navProp) continue;
            return item;
        }
        ExpandItem item = new ExpandItem(navProp);
        this.items.add(item);
        return item;
    }

    public ExpandItem getItemFor(NavigationProperty navProp) {
        for (ExpandItem item : this.items) {
            if (item.navProp != navProp) continue;
            return item;
        }
        return null;
    }

    public Expand addItem(ExpandItem item) {
        this.items.add(item);
        return this;
    }

    public String toUrl() {
        StringBuilder result = new StringBuilder();
        String join = "";
        for (ExpandItem item : this.items) {
            result.append(join).append(item.toUrl());
            join = ",";
        }
        return result.toString();
    }

    public static class ExpandItem
    implements QueryParameter<ExpandItem> {
        private final NavigationProperty navProp;
        private Boolean count;
        private String[] select;
        private String filter;
        private String orderby;
        private int skip = -1;
        private int top = -1;
        private Expand expand;

        public ExpandItem(NavigationProperty navProp) {
            this.navProp = navProp;
        }

        public boolean isCount() {
            return this.count;
        }

        @Override
        public ExpandItem count(Boolean count) {
            this.count = count;
            return this;
        }

        @Override
        public ExpandItem select(String ... fields) {
            this.select = fields;
            return this;
        }

        public String[] getSelect() {
            return this.select;
        }

        public String getFilter() {
            return this.filter;
        }

        @Override
        public ExpandItem filter(String filter) {
            this.filter = filter;
            return this;
        }

        public String getOrderby() {
            return this.orderby;
        }

        @Override
        public ExpandItem orderBy(String orderby) {
            this.orderby = orderby;
            return this;
        }

        public int getSkip() {
            return this.skip;
        }

        @Override
        public ExpandItem skip(int skip) {
            this.skip = skip;
            return this;
        }

        public int getTop() {
            return this.top;
        }

        @Override
        public ExpandItem top(int top) {
            this.top = top;
            return this;
        }

        public Expand getExpand() {
            return this.expand;
        }

        @Override
        public ExpandItem expand(Expand expand) {
            this.expand = expand;
            if (this.navProp != null) {
                expand.onType = this.navProp.getEntityType();
            }
            return this;
        }

        @Override
        public ExpandItem addExpandItem(ExpandItem item) {
            if (this.expand == null) {
                this.expand = new Expand();
                this.expand.onType = this.navProp.getEntityType();
            }
            this.expand.addItem(item);
            return this;
        }

        public String toUrlAsQuery() {
            StringBuilder target = new StringBuilder();
            this.paramsToUrl(target, "&");
            return target.toString();
        }

        public String toUrl() {
            StringBuilder target = new StringBuilder();
            this.paramsToUrl(target, ";");
            if (target.isEmpty()) {
                return this.navProp.getName();
            }
            return this.navProp.getName() + "(" + target.toString() + ")";
        }

        private void paramsToUrl(StringBuilder target, String separator) {
            String join = "";
            if (this.skip > 0) {
                target.append("$skip=").append(this.skip);
                join = separator;
            }
            if (this.top >= 0) {
                target.append(join).append("$top=").append(this.top);
                join = separator;
            }
            if (this.select != null && this.select.length > 0) {
                target.append(join).append("$select=").append(String.join((CharSequence)",", this.select));
                join = separator;
            }
            if (!StringHelper.isNullOrEmpty(this.filter)) {
                target.append(join).append("$filter=").append(this.filter);
                join = separator;
            }
            if (!StringHelper.isNullOrEmpty(this.orderby)) {
                target.append(join).append("$orderby=").append(this.orderby);
                join = separator;
            }
            if (this.count != null) {
                target.append(join).append("$count=").append(this.count.toString());
                join = separator;
            }
            if (this.expand != null) {
                target.append(join).append("$expand=").append(this.expand.toUrl());
            }
        }
    }
}

