/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.models.swecommon.simple;

import com.fasterxml.jackson.databind.JsonNode;
import de.fraunhofer.iosb.ilt.frostclient.models.swecommon.constraint.AllowedTimes;
import de.fraunhofer.iosb.ilt.frostclient.models.swecommon.simple.AbstractSimpleComponent;
import de.fraunhofer.iosb.ilt.frostclient.models.swecommon.util.UnitOfMeasurement;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Time
extends AbstractSimpleComponent<Time, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Time.class.getName());
    private String referenceTime;
    private String localFrame;
    private UnitOfMeasurement uom;
    private AllowedTimes constraint;
    private String value;

    public String getReferenceTime() {
        return this.referenceTime;
    }

    public Time setReferenceTime(String referenceTime) {
        this.referenceTime = referenceTime;
        return this;
    }

    public String getLocalFrame() {
        return this.localFrame;
    }

    public Time setLocalFrame(String localFrame) {
        this.localFrame = localFrame;
        return this;
    }

    public UnitOfMeasurement getUom() {
        return this.uom;
    }

    public Time setUom(UnitOfMeasurement uom) {
        this.uom = uom;
        return this;
    }

    public AllowedTimes getConstraint() {
        return this.constraint;
    }

    public Time setConstraint(AllowedTimes constraint) {
        this.constraint = constraint;
        return this;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public Time setValue(String value) {
        this.value = value;
        return this;
    }

    @Override
    public boolean valueIsValid() {
        return this.validate(this.value);
    }

    @Override
    public boolean validate(Object input) {
        if (input == null) {
            return this.isOptional() || this.isSecret();
        }
        if (input instanceof JsonNode) {
            JsonNode j = (JsonNode)input;
            return this.validate(j);
        }
        if (input instanceof String) {
            String s = (String)input;
            return this.validate(s);
        }
        LOGGER.debug("Non-String value {} for Text.", input);
        return false;
    }

    @Override
    public boolean validate(JsonNode input) {
        if (input == null) {
            return this.isOptional() || this.isSecret();
        }
        if (!input.isTextual()) {
            LOGGER.debug("Non-Text value {} for Text.", (Object)input);
            return false;
        }
        return this.validate(input.asText());
    }

    public boolean validate(String input) {
        if (input == null) {
            return this.isOptional() || this.isSecret();
        }
        if (this.constraint == null) {
            return true;
        }
        return this.constraint.isValid(input, this.getUom());
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 19 * hash + Objects.hashCode(this.referenceTime);
        hash = 19 * hash + Objects.hashCode(this.localFrame);
        hash = 19 * hash + Objects.hashCode(this.uom);
        hash = 19 * hash + Objects.hashCode(this.constraint);
        hash = 19 * hash + Objects.hashCode(this.value);
        hash = 19 * hash + super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Time other = (Time)obj;
        if (!Objects.equals(this.referenceTime, other.referenceTime)) {
            return false;
        }
        if (!Objects.equals(this.localFrame, other.localFrame)) {
            return false;
        }
        if (!Objects.equals(this.uom, other.uom)) {
            return false;
        }
        if (!Objects.equals(this.value, other.value)) {
            return false;
        }
        if (!Objects.equals(this.constraint, other.constraint)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    protected Time self() {
        return this;
    }
}

