/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.models.swecommon.simple;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.fraunhofer.iosb.ilt.frostclient.models.swecommon.constraint.AllowedTokens;
import de.fraunhofer.iosb.ilt.frostclient.models.swecommon.simple.AbstractSimpleComponent;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Text
extends AbstractSimpleComponent<Text, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Text.class.getName());
    private String value;
    private AllowedTokens constraint;

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Objects.hashCode(this.value);
        hash = 59 * hash + Objects.hashCode(this.constraint);
        hash = 59 * hash + super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Text other = (Text)obj;
        if (!Objects.equals(this.value, other.value)) {
            return false;
        }
        if (!Objects.equals(this.constraint, other.constraint)) {
            return false;
        }
        return super.equals(obj);
    }

    public AllowedTokens getConstraint() {
        return this.constraint;
    }

    public Text setConstraint(AllowedTokens constraint) {
        this.constraint = constraint;
        return this;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public Text setValue(String value) {
        this.value = value;
        return this;
    }

    @Override
    public boolean valueIsValid() {
        return this.validate(this.value);
    }

    @Override
    public boolean validate(Object input) {
        if (input == null) {
            return this.isOptional() || this.isSecret();
        }
        if (input instanceof JsonNode) {
            JsonNode j = (JsonNode)input;
            return this.validate(j);
        }
        if (input instanceof String) {
            String s = (String)input;
            return this.validate(s);
        }
        LOGGER.debug("Non-String value {} for Text.", input);
        return false;
    }

    @Override
    public boolean validate(JsonNode input) {
        if (input == null) {
            return this.isOptional() || this.isSecret();
        }
        if (!input.isTextual()) {
            LOGGER.debug("Non-Text value {} for Text.", (Object)input);
            return false;
        }
        return this.validate(input.asText());
    }

    public boolean validate(String input) {
        if (input == null) {
            return this.isOptional() || this.isSecret();
        }
        if (this.constraint == null) {
            return true;
        }
        return this.constraint.isValid(input);
    }

    @Override
    protected Text self() {
        return this;
    }

    @Override
    public ObjectNode asJsonSchema() {
        ObjectNode schema = super.asJsonSchema().put("type", "string");
        if (this.constraint != null) {
            this.constraint.addToSchema(schema);
        }
        return schema;
    }
}

