/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.models.swecommon.simple;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.fraunhofer.iosb.ilt.frostclient.models.swecommon.constraint.AllowedValues;
import de.fraunhofer.iosb.ilt.frostclient.models.swecommon.simple.AbstractSimpleComponent;
import de.fraunhofer.iosb.ilt.frostclient.models.swecommon.util.UnitOfMeasurement;
import java.math.BigDecimal;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Quantity
extends AbstractSimpleComponent<Quantity, Number> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Quantity.class.getName());
    private Number value;
    private AllowedValues constraint;
    private UnitOfMeasurement uom;

    public Quantity setConstraint(AllowedValues constraint) {
        this.constraint = constraint;
        return this;
    }

    public Quantity setUom(UnitOfMeasurement uom) {
        this.uom = uom;
        return this;
    }

    @Override
    public Number getValue() {
        return this.value;
    }

    @Override
    public Quantity setValue(Number value) {
        this.value = value;
        return this;
    }

    @Override
    public boolean valueIsValid() {
        return this.validate(this.value);
    }

    @Override
    public boolean validate(Object input) {
        if (input == null) {
            return this.isOptional() || this.isSecret();
        }
        if (input instanceof JsonNode) {
            JsonNode j = (JsonNode)input;
            return this.validate(j);
        }
        if (input instanceof Number) {
            Number n = (Number)input;
            return this.validate(n);
        }
        LOGGER.debug("Non-integral value {} for Count.", input);
        return false;
    }

    @Override
    public boolean validate(JsonNode input) {
        if (input == null) {
            return this.isOptional() || this.isSecret();
        }
        if (!input.isNumber()) {
            LOGGER.debug("Non-number value {} for Count.", (Object)input);
            return false;
        }
        return this.validate(input.decimalValue());
    }

    public boolean validate(Number input) {
        if (input == null) {
            return this.isOptional() || this.isSecret();
        }
        if (this.constraint == null) {
            return true;
        }
        if (input instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)input;
            return this.constraint.isValid(bd);
        }
        return this.constraint.isValid(new BigDecimal(input.toString()));
    }

    public UnitOfMeasurement getUom() {
        return this.uom;
    }

    public AllowedValues getConstraint() {
        return this.constraint;
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + Objects.hashCode(this.value);
        hash = 53 * hash + Objects.hashCode(this.constraint);
        hash = 53 * hash + Objects.hashCode(this.uom);
        hash = 53 * hash + super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Quantity other = (Quantity)obj;
        if (!Objects.equals(this.uom, other.uom)) {
            return false;
        }
        if (!Objects.equals(this.value, other.value)) {
            return false;
        }
        if (!Objects.equals(this.constraint, other.constraint)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    protected Quantity self() {
        return this;
    }

    @Override
    public ObjectNode asJsonSchema() {
        ObjectNode schema = super.asJsonSchema().put("type", "numer");
        if (this.constraint != null) {
            this.constraint.addToSchema(schema);
        }
        return schema;
    }
}

