/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.models.swecommon.constraint;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.fraunhofer.iosb.ilt.frostclient.models.swecommon.constraint.AbstractConstraint;
import de.fraunhofer.iosb.ilt.frostclient.utils.StringHelper;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

public class AllowedValues
extends AbstractConstraint<AllowedValues> {
    private List<BigDecimal> values;
    private List<List<BigDecimal>> intervals;
    private Integer significantFigures;

    public List<BigDecimal> getValues() {
        return this.values;
    }

    public AllowedValues setValues(List<BigDecimal> values) {
        this.values = values;
        return this;
    }

    public List<List<BigDecimal>> getIntervals() {
        return this.intervals;
    }

    public AllowedValues setIntervals(List<List<BigDecimal>> intervals) {
        this.intervals = intervals;
        return this;
    }

    public Integer getSignificantFigures() {
        return this.significantFigures;
    }

    public AllowedValues setSignificantFigures(Integer significantFigures) {
        this.significantFigures = significantFigures;
        return this;
    }

    public boolean isValid(BigDecimal input) {
        if (StringHelper.isNullOrEmpty(this.values) && StringHelper.isNullOrEmpty(this.intervals) && this.significantFigures == 0) {
            return true;
        }
        if (this.values != null) {
            for (BigDecimal bigDecimal : this.values) {
                if (bigDecimal.compareTo(input) != 0) continue;
                return true;
            }
        }
        if (this.intervals != null) {
            for (List list : this.intervals) {
                if (((BigDecimal)list.get(0)).compareTo(input) >= 0 || ((BigDecimal)list.get(1)).compareTo(input) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + Objects.hashCode(this.values);
        hash = 17 * hash + Objects.hashCode(this.intervals);
        hash = 17 * hash + Objects.hashCode(this.significantFigures);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AllowedValues other = (AllowedValues)obj;
        if (!Objects.equals(this.values, other.values)) {
            return false;
        }
        if (!Objects.equals(this.intervals, other.intervals)) {
            return false;
        }
        return Objects.equals(this.significantFigures, other.significantFigures);
    }

    @Override
    protected AllowedValues self() {
        return this;
    }

    @Override
    public void addToSchema(ObjectNode schema) {
        if (this.values != null) {
            ArrayNode children = new ArrayNode(JsonNodeFactory.instance);
            this.values.stream().forEach(t -> children.add(t));
            schema.set("enum", (JsonNode)children);
        }
        if (this.intervals != null && !this.intervals.isEmpty()) {
            List<BigDecimal> interval = this.intervals.get(0);
            if (!interval.isEmpty()) {
                schema.put("minimum", interval.get(0));
            }
            if (interval.size() > 1) {
                schema.put("maximum", interval.get(1));
            }
        }
    }
}

