/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.models.swecommon.constraint;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.fraunhofer.iosb.ilt.frostclient.models.swecommon.constraint.AbstractConstraint;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

public class AllowedTokens
extends AbstractConstraint<AllowedTokens> {
    private List<String> values;
    private String pattern;

    public AllowedTokens() {
    }

    public AllowedTokens(String ... tokens) {
        this.values = Arrays.asList(tokens);
    }

    public AllowedTokens(String pattern) {
        this.pattern = pattern;
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + Objects.hashCode(this.values);
        hash = 37 * hash + Objects.hashCode(this.pattern);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AllowedTokens other = (AllowedTokens)obj;
        if (!Objects.equals(this.pattern, other.pattern)) {
            return false;
        }
        return Objects.equals(this.values, other.values);
    }

    public String getPattern() {
        return this.pattern;
    }

    public AllowedTokens setPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public List<String> getValues() {
        return this.values;
    }

    public AllowedTokens setValues(List<String> values) {
        this.values = values;
        return this;
    }

    public boolean isValid(String input) {
        Pattern compiled;
        if (this.values != null) {
            for (String item : this.values) {
                if (!item.equals(input)) continue;
                return true;
            }
        }
        return this.pattern != null && !this.pattern.isEmpty() && (compiled = Pattern.compile(this.pattern)).matcher(input).matches();
    }

    @Override
    protected AllowedTokens self() {
        return this;
    }

    @Override
    public void addToSchema(ObjectNode schema) {
        if (this.pattern != null) {
            schema.put("pattern", this.pattern);
        } else if (this.values != null) {
            ArrayNode children = new ArrayNode(JsonNodeFactory.instance);
            this.values.stream().forEach(t -> children.add(t));
            schema.set("enum", (JsonNode)children);
        }
    }
}

