/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.models.swecommon;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.fraunhofer.iosb.ilt.frostclient.json.deserialize.SweTypeIdResolver;
import de.fraunhofer.iosb.ilt.frostclient.models.swecommon.AbstractSWE;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeIdResolver(value=SweTypeIdResolver.class)
public abstract class AbstractSWEIdentifiable<T extends AbstractSWEIdentifiable<T>>
extends AbstractSWE {
    private String identifier;
    private String label;
    private String description;
    private String type;

    public String getDescription() {
        return this.description;
    }

    public T setDescription(String description) {
        this.description = description;
        return this.self();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public T setIdentifier(String identifier) {
        this.identifier = identifier;
        return this.self();
    }

    public String getLabel() {
        return this.label;
    }

    public T setLabel(String label) {
        this.label = label;
        return this.self();
    }

    public String getType() {
        return this.type;
    }

    public T setType(String type) {
        this.type = type;
        return this.self();
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + Objects.hashCode(this.identifier);
        hash = 67 * hash + Objects.hashCode(this.label);
        hash = 67 * hash + Objects.hashCode(this.description);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractSWEIdentifiable other = (AbstractSWEIdentifiable)obj;
        if (!Objects.equals(this.identifier, other.identifier)) {
            return false;
        }
        if (!Objects.equals(this.label, other.label)) {
            return false;
        }
        return Objects.equals(this.description, other.description);
    }

    protected abstract T self();

    @Override
    public ObjectNode asJsonSchema() {
        ObjectNode schema = new ObjectNode(JsonNodeFactory.instance).put("title", this.getLabel()).put("description", this.getDescription());
        return schema;
    }
}

