/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.models.swecommon;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.fraunhofer.iosb.ilt.frostclient.models.swecommon.AbstractSWEIdentifiable;
import java.util.Objects;

public abstract class AbstractDataComponent<T extends AbstractDataComponent<T, V>, V>
extends AbstractSWEIdentifiable<T> {
    private String name;
    private boolean secret;
    private String definition;
    private boolean optional;
    private boolean updatable;

    public String getDefinition() {
        return this.definition;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Objects.hashCode(this.definition);
        hash = 29 * hash + (this.optional ? 1 : 0);
        hash = 29 * hash + (this.updatable ? 1 : 0);
        hash = 29 * hash + super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractDataComponent other = (AbstractDataComponent)obj;
        if (this.optional != other.optional) {
            return false;
        }
        if (this.updatable != other.updatable) {
            return false;
        }
        if (!Objects.equals(this.definition, other.definition)) {
            return false;
        }
        return super.equals(obj);
    }

    public String getName() {
        return this.name;
    }

    public T setName(String name) {
        this.name = name;
        return (T)((AbstractDataComponent)this.self());
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isOptional() {
        return this.optional;
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isUpdatable() {
        return this.updatable;
    }

    public abstract boolean valueIsValid();

    public abstract V getValue();

    public abstract T setValue(V var1);

    public abstract boolean validate(Object var1);

    public abstract boolean validate(JsonNode var1);

    public T setDefinition(String definition) {
        this.definition = definition;
        return (T)((AbstractDataComponent)this.self());
    }

    public T setOptional(boolean optional) {
        this.optional = optional;
        return (T)((AbstractDataComponent)this.self());
    }

    public T setUpdatable(boolean updatable) {
        this.updatable = updatable;
        return (T)((AbstractDataComponent)this.self());
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isSecret() {
        return this.secret;
    }

    public T setSecret(boolean secret) {
        this.secret = secret;
        return (T)((AbstractDataComponent)this.self());
    }

    @Override
    public ObjectNode asJsonSchema() {
        ObjectNode schema = super.asJsonSchema();
        if (this.isSecret()) {
            schema.put("secret", this.isSecret());
        }
        return schema;
    }
}

