/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.models.ext;

import com.fasterxml.jackson.core.JsonProcessingException;
import de.fraunhofer.iosb.ilt.frostclient.json.SimpleJsonMapper;
import de.fraunhofer.iosb.ilt.frostclient.model.ComplexValue;
import de.fraunhofer.iosb.ilt.frostclient.model.Property;
import de.fraunhofer.iosb.ilt.frostclient.model.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostclient.models.CommonProperties;
import de.fraunhofer.iosb.ilt.frostclient.models.SensorThingsV11Sensing;
import java.util.Objects;

public class UnitOfMeasurement
implements ComplexValue<UnitOfMeasurement> {
    public static final EntityPropertyMain<String> EP_NAME = CommonProperties.EP_NAME;
    public static final EntityPropertyMain<String> EP_DEFINITION = CommonProperties.EP_DEFINITION;
    public static final EntityPropertyMain<String> EP_SYMBOL = SensorThingsV11Sensing.EP_SYMBOL;
    private String name;
    private String symbol;
    private String definition;

    public UnitOfMeasurement() {
    }

    public UnitOfMeasurement(String name, String symbol, String definition) {
        this.name = name;
        this.symbol = symbol;
        this.definition = definition;
    }

    public String getName() {
        return this.name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getDefinition() {
        return this.definition;
    }

    @Override
    public <P> P getProperty(Property<P> property) {
        if (property == EP_NAME) {
            return (P)this.getName();
        }
        if (property == EP_SYMBOL) {
            return (P)this.getSymbol();
        }
        if (property == EP_DEFINITION) {
            return (P)this.getDefinition();
        }
        throw new IllegalArgumentException("Unknown sub-property: " + String.valueOf(property));
    }

    @Override
    public <P> UnitOfMeasurement setProperty(Property<P> property, P value) {
        if (property == EP_NAME) {
            return this.setName(Objects.toString(value));
        }
        if (property == EP_SYMBOL) {
            return this.setSymbol(Objects.toString(value));
        }
        if (property == EP_DEFINITION) {
            return this.setDefinition(Objects.toString(value));
        }
        throw new IllegalArgumentException("Unknown sub-property: " + String.valueOf(property));
    }

    @Override
    public Object getProperty(String name) {
        throw new IllegalArgumentException("Can not get custom properties from UnitOfMeasurement");
    }

    @Override
    public UnitOfMeasurement setProperty(String name, Object value) {
        throw new IllegalArgumentException("Can not set custom properties on UnitOfMeasurement");
    }

    public UnitOfMeasurement setName(String name) {
        this.name = name;
        return this;
    }

    public UnitOfMeasurement setSymbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    public UnitOfMeasurement setDefinition(String definition) {
        this.definition = definition;
        return this;
    }

    public String toString() {
        try {
            return SimpleJsonMapper.getSimpleObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException ex) {
            return super.toString();
        }
    }

    public int hashCode() {
        return Objects.hash(this.name, this.symbol, this.definition);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnitOfMeasurement other = (UnitOfMeasurement)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.symbol, other.symbol)) {
            return false;
        }
        return Objects.equals(this.definition, other.definition);
    }
}

