/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.models.ext;

import de.fraunhofer.iosb.ilt.frostclient.model.ComplexValue;
import de.fraunhofer.iosb.ilt.frostclient.model.Property;
import de.fraunhofer.iosb.ilt.frostclient.model.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostclient.model.property.type.TypeComplex;
import de.fraunhofer.iosb.ilt.frostclient.models.ext.TimeInstant;
import de.fraunhofer.iosb.ilt.frostclient.models.ext.TimeInterval;
import de.fraunhofer.iosb.ilt.frostclient.models.ext.TimeObject;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Objects;
import net.time4j.Moment;

public class TimeValue
implements TimeObject,
ComplexValue<TimeValue> {
    public static EntityPropertyMain<TimeInstant> EP_START_TIME = TypeComplex.EP_START_TIME;
    public static EntityPropertyMain<TimeInstant> EP_END_TIME = TypeComplex.EP_END_TIME;
    private TimeInstant instant;
    private TimeInterval interval;

    public TimeValue() {
        this.instant = null;
        this.interval = null;
    }

    public TimeValue(TimeInstant timeInstant) {
        this.instant = timeInstant;
        this.interval = null;
    }

    public TimeValue(TimeInterval timeInterval) {
        this.instant = null;
        this.interval = timeInterval;
    }

    public static TimeValue create(TimeInstant instant) {
        return new TimeValue(instant);
    }

    public static TimeValue create(TimeInterval timeInterval) {
        return new TimeValue(timeInterval);
    }

    public static TimeValue create(Moment start, Moment end) {
        return new TimeValue(TimeInterval.create(start, end));
    }

    public static TimeValue create(Instant start, Instant end) {
        return new TimeValue(TimeInterval.create(start, end));
    }

    public static TimeValue create(ZonedDateTime start, ZonedDateTime end) {
        return new TimeValue(TimeInterval.create(start, end));
    }

    public static TimeValue create(Moment instant) {
        return new TimeValue(new TimeInstant(instant));
    }

    public static TimeValue create(Instant instant) {
        return new TimeValue(TimeInstant.create(instant));
    }

    public static TimeValue create(ZonedDateTime zdt) {
        return new TimeValue(TimeInstant.create(zdt));
    }

    public boolean isInstant() {
        return this.instant != null;
    }

    public TimeInstant getInstant() {
        return this.instant;
    }

    public boolean isInterval() {
        return this.interval != null;
    }

    public TimeInterval getInterval() {
        return this.interval;
    }

    @Override
    public String asISO8601() {
        return this.instant == null ? this.interval.asISO8601() : this.instant.asISO8601();
    }

    @Override
    public boolean isEmpty() {
        if (this.instant != null) {
            return this.instant.isEmpty();
        }
        if (this.interval != null) {
            return this.interval.isEmpty();
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeValue other = (TimeValue)obj;
        if (!Objects.equals(this.instant, other.instant)) {
            return false;
        }
        return Objects.equals(this.interval, other.interval);
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.instant);
        hash = 67 * hash + Objects.hashCode(this.interval);
        return hash;
    }

    @Override
    public <P> P getProperty(Property<P> property) {
        if (property != EP_START_TIME && property != EP_END_TIME) {
            throw new IllegalArgumentException("Unknown sub-property: " + String.valueOf(property));
        }
        if (this.isInterval()) {
            return this.interval.getProperty(property);
        }
        return (P)this.instant;
    }

    @Override
    public <P> TimeValue setProperty(Property<P> property, P value) {
        Moment moment;
        if (value == null) {
            moment = null;
        } else if (value instanceof Moment) {
            Moment m;
            moment = m = (Moment)value;
        } else if (value instanceof Instant) {
            Instant i = (Instant)value;
            moment = Moment.from((Instant)i);
        } else if (value instanceof TimeInstant) {
            TimeInstant ti = (TimeInstant)value;
            moment = ti.getDateTime();
        } else {
            throw new IllegalArgumentException("TimeValue only accepts Moment, Instant or TimeInstant, not " + value.getClass().getName());
        }
        if (property == EP_START_TIME) {
            if (moment == null) {
                return this;
            }
            if (this.instant != null) {
                this.instant = new TimeInstant(moment);
            } else {
                this.interval.setProperty((Property)property, (Object)moment);
            }
            return this;
        }
        if (property == EP_END_TIME) {
            if (this.instant != null) {
                if (moment == null) {
                    return this;
                }
                this.interval = TimeInterval.create(this.instant.getDateTime(), moment);
                this.instant = null;
            } else if (moment == null) {
                this.instant = TimeInstant.create(this.interval.getStart());
                this.interval = null;
            } else {
                this.interval.setProperty((Property)property, (Object)moment);
            }
            return this;
        }
        throw new IllegalArgumentException("Unknown sub-property: " + String.valueOf(property));
    }

    @Override
    public Object getProperty(String name) {
        throw new IllegalArgumentException("Can not get custom properties from TimeValue");
    }

    @Override
    public TimeValue setProperty(String name, Object value) {
        throw new IllegalArgumentException("Can not set custom properties on TimeValue");
    }

    public String toString() {
        if (this.interval != null) {
            return this.interval.toString();
        }
        if (this.instant != null) {
            return this.instant.toString();
        }
        return "null";
    }
}

