/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.model.csdl;

import de.fraunhofer.iosb.ilt.frostclient.model.EntityType;
import de.fraunhofer.iosb.ilt.frostclient.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlPropertyEntity;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlPropertyNavigation;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlSchemaItemAbstract;
import de.fraunhofer.iosb.ilt.frostclient.model.property.type.TypeComplex;
import de.fraunhofer.iosb.ilt.frostclient.utils.ParserUtils;
import java.util.Map;
import java.util.Objects;

public abstract class CsdlProperty
extends CsdlSchemaItemAbstract {
    public CsdlProperty(String kind) {
        super(kind);
    }

    public abstract void applyTo(ModelRegistry var1, EntityType var2, String var3);

    public abstract void applyTo(ModelRegistry var1, TypeComplex var2, String var3);

    public static CsdlProperty of(String name, Map data) {
        String type = Objects.toString(data.get("$Type"), "Edm.String");
        String kind = Objects.toString(data.get("$Kind"), "Property");
        boolean nullable = ParserUtils.objectToBoolean(data.get("$Nullable"), false);
        boolean collection = ParserUtils.objectToBoolean(data.get("$Collection"), false);
        switch (kind) {
            case "Property": {
                return new CsdlPropertyEntity().setType(type).setNullable(nullable).setCollection(collection);
            }
            case "NavigationProperty": {
                String partner = Objects.toString(data.get("$Partner"));
                return new CsdlPropertyNavigation().setType(type).setCollection(collection).setNullable(nullable).setPartner(partner);
            }
        }
        return null;
    }
}

