/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.model;

import de.fraunhofer.iosb.ilt.frostclient.SensorThingsService;
import de.fraunhofer.iosb.ilt.frostclient.dao.BaseDao;
import de.fraunhofer.iosb.ilt.frostclient.dao.Dao;
import de.fraunhofer.iosb.ilt.frostclient.exception.MqttException;
import de.fraunhofer.iosb.ilt.frostclient.exception.ServiceFailureException;
import de.fraunhofer.iosb.ilt.frostclient.exception.StatusCodeException;
import de.fraunhofer.iosb.ilt.frostclient.model.ComplexValue;
import de.fraunhofer.iosb.ilt.frostclient.model.EntitySet;
import de.fraunhofer.iosb.ilt.frostclient.model.EntityType;
import de.fraunhofer.iosb.ilt.frostclient.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostclient.model.PkValue;
import de.fraunhofer.iosb.ilt.frostclient.model.PrimaryKey;
import de.fraunhofer.iosb.ilt.frostclient.model.Property;
import de.fraunhofer.iosb.ilt.frostclient.model.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationProperty;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationPropertyEntity;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationPropertyEntitySet;
import de.fraunhofer.iosb.ilt.frostclient.query.Expand;
import de.fraunhofer.iosb.ilt.frostclient.query.Query;
import de.fraunhofer.iosb.ilt.frostclient.utils.MqttSubscription;
import de.fraunhofer.iosb.ilt.frostclient.utils.ParserUtils;
import de.fraunhofer.iosb.ilt.frostclient.utils.StringHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Entity
implements ComplexValue<Entity> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Entity.class.getName());
    private EntityType entityType;
    private final Map<EntityPropertyMain, Object> entityProperties = new HashMap<EntityPropertyMain, Object>();
    private final Map<NavigationProperty, Object> navProperties = new HashMap<NavigationProperty, Object>();
    private final Set<Property> setProperties = new HashSet<Property>();
    private SensorThingsService service;
    private Expand expand;
    private String selfLink;

    public Entity(EntityType entityType) {
        this.entityType = entityType;
    }

    public final PrimaryKey getPrimaryKey() {
        return this.entityType.getPrimaryKey();
    }

    public final PkValue getPrimaryKeyValues() {
        List<EntityPropertyMain> keyProperties = this.entityType.getPrimaryKey().getKeyProperties();
        PkValue pkValue = new PkValue(keyProperties.size());
        int idx = 0;
        for (EntityPropertyMain keyProperty : keyProperties) {
            pkValue.set(idx, this.getProperty(keyProperty));
            ++idx;
        }
        return pkValue;
    }

    public boolean primaryKeyFullySet() {
        List<EntityPropertyMain> keyProperties = this.entityType.getPrimaryKey().getKeyProperties();
        for (EntityPropertyMain keyProperty : keyProperties) {
            Object value = this.getProperty(keyProperty);
            if (value != null) continue;
            return false;
        }
        return true;
    }

    public final Entity setPrimaryKeyValues(PkValue values) {
        int idx = 0;
        for (EntityPropertyMain keyProperty : this.entityType.getPrimaryKey().getKeyProperties()) {
            if (idx >= values.size()) {
                throw new IllegalArgumentException("No value given for keyProperty " + idx);
            }
            this.setProperty((Property)keyProperty, values.get(idx));
            ++idx;
        }
        return this;
    }

    public String getSelfLink() {
        return this.getSelfLink(true);
    }

    public String getSelfLink(boolean absolute) {
        if (this.selfLink != null && this.selfLink.startsWith("http") == absolute) {
            return this.selfLink;
        }
        if (absolute) {
            try {
                return String.valueOf(this.service.getFullPath(this.entityType)) + "(" + StringHelper.formatKeyValuesForUrl(this.entityType.getPrimaryKey(), this.getPrimaryKeyValues()) + ")";
            }
            catch (ServiceFailureException ex) {
                throw new IllegalStateException("Failed to generate selfLink", ex);
            }
        }
        return this.entityType.mainSet + "(" + StringHelper.formatKeyValuesForUrl(this.entityType.getPrimaryKey(), this.getPrimaryKeyValues()) + ")";
    }

    public Entity setSelfLink(String selfLink) {
        this.selfLink = selfLink;
        return this;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public Entity setEntityType(EntityType entityType) {
        if (this.entityType != null) {
            throw new IllegalArgumentException("the type of this entity is alread yet to " + this.entityType.entityName);
        }
        this.entityType = entityType;
        return this;
    }

    public boolean isSetProperty(Property property) {
        if (property == ModelRegistry.EP_SELFLINK) {
            return true;
        }
        return this.setProperties.contains(property);
    }

    @Override
    public <P> P getProperty(Property<P> property) {
        return this.getProperty(property, true);
    }

    public Entity getProperty(NavigationPropertyEntity property) throws ServiceFailureException {
        return this.getProperty(property, true);
    }

    public Entity getProperty(NavigationPropertyEntity npe, boolean autoLoad) throws ServiceFailureException {
        Entity entity = (Entity)this.navProperties.get(npe);
        if (entity == null && autoLoad && this.service != null) {
            try {
                entity = this.service.dao(npe.getEntityType()).find(this, npe);
                this.setProperty((Property)npe, (Object)entity);
            }
            catch (StatusCodeException ex) {
                int statusCode = ex.getStatusCode();
                if (statusCode == 404 || statusCode == 204) {
                    return null;
                }
                throw ex;
            }
        } else if (entity != null && this.service != null && entity.getService() == null) {
            entity.setService(this.service);
        }
        return entity;
    }

    public <P> P getProperty(Property<P> property, boolean autoLoad) {
        if (property == null) {
            return null;
        }
        if (property == ModelRegistry.EP_SELFLINK) {
            return (P)this.getSelfLink();
        }
        if (!this.entityType.hasProperty(property)) {
            throw new IllegalArgumentException(this.entityType.entityName + " has no property " + property.getName());
        }
        if (property instanceof EntityPropertyMain) {
            EntityPropertyMain epm = (EntityPropertyMain)property;
            return (P)this.entityProperties.get(epm);
        }
        if (property instanceof NavigationPropertyEntity) {
            NavigationPropertyEntity npe = (NavigationPropertyEntity)property;
            try {
                return (P)this.getProperty(npe, autoLoad);
            }
            catch (ServiceFailureException ex) {
                LOGGER.error("Failed to load linked entity {}", (Object)npe, (Object)ex.getMessage());
                throw new RuntimeException(ex);
            }
        }
        if (property instanceof NavigationPropertyEntitySet) {
            NavigationPropertyEntitySet npes = (NavigationPropertyEntitySet)property;
            EntitySet entitySet = (EntitySet)this.navProperties.get(npes);
            if (entitySet == null && autoLoad) {
                entitySet = new EntitySet(this, npes);
                if (autoLoad && this.service != null) {
                    String startLink = this.service.getFullPathString(this, npes);
                    entitySet.setInitialLink(startLink);
                    entitySet.setNextLink(startLink);
                    entitySet.setExpandItem(this.getExpandItemFor(npes));
                }
                this.setProperty((Property)npes, (Object)entitySet);
            }
            if (entitySet != null && this.service != null && entitySet.getService() == null) {
                entitySet.setService(this.service);
            }
            return (P)entitySet;
        }
        return null;
    }

    @Override
    public Object getProperty(String name) {
        throw new IllegalArgumentException("Can not get custom properties from Entity " + String.valueOf(this.entityType));
    }

    @Override
    public Entity setProperty(String name, Object value) {
        throw new IllegalArgumentException("Can not set custom properties on Entity " + String.valueOf(this.entityType));
    }

    @Override
    public <P> Entity setProperty(Property<P> property, P value) {
        if (property == ModelRegistry.EP_SELFLINK) {
            this.setSelfLink(String.valueOf(value));
            return this;
        }
        if (!this.entityType.hasProperty(property)) {
            throw new IllegalArgumentException(this.entityType.entityName + " has no property " + property.getName());
        }
        if (property instanceof EntityPropertyMain) {
            EntityPropertyMain epm = (EntityPropertyMain)property;
            this.entityProperties.put(epm, value);
            this.setProperties.add(property);
        } else if (property instanceof NavigationProperty) {
            NavigationProperty np = (NavigationProperty)property;
            this.navProperties.put(np, value);
            if (value == null) {
                this.setProperties.remove(property);
            } else {
                this.setProperties.add(property);
            }
        }
        return this;
    }

    public Entity unsetProperty(Property property) {
        if (property instanceof EntityPropertyMain) {
            EntityPropertyMain epm = (EntityPropertyMain)property;
            this.entityProperties.remove(epm);
        } else if (property instanceof NavigationProperty) {
            NavigationProperty np = (NavigationProperty)property;
            this.navProperties.remove(np);
        }
        this.setProperties.remove(property);
        return this;
    }

    public Entity addNavigationEntity(NavigationPropertyEntitySet navProperty, Entity linkedEntity) {
        EntitySet entitySet = this.getProperty(navProperty);
        if (entitySet == null) {
            entitySet = new EntitySet(this, navProperty);
            this.setProperty((Property)navProperty, (Object)entitySet);
        }
        entitySet.add(linkedEntity);
        return this;
    }

    public Entity addNavigationEntity(NavigationPropertyEntitySet navProperty, List<Entity> linkedEntities) {
        for (Entity linkedEntity : linkedEntities) {
            this.addNavigationEntity(navProperty, linkedEntity);
        }
        return this;
    }

    public Entity addNavigationEntity(NavigationPropertyEntitySet navProperty, Entity ... linkedEntities) {
        for (Entity linkedEntity : linkedEntities) {
            this.addNavigationEntity(navProperty, linkedEntity);
        }
        return this;
    }

    public boolean hasService() {
        return this.service != null;
    }

    public SensorThingsService getService() {
        return this.service;
    }

    public void setService(SensorThingsService service) {
        this.service = service;
    }

    public void ensureService() throws IllegalArgumentException {
        if (this.service == null) {
            throw new IllegalArgumentException("Can not subscribe, entity not sent to service yet.");
        }
    }

    public Expand getExpand() {
        return this.expand;
    }

    public Expand.ExpandItem getExpandItemFor(NavigationProperty navProp) {
        if (this.expand == null) {
            return null;
        }
        return this.expand.getItemFor(navProp);
    }

    public void setExpand(Expand expand) {
        this.expand = expand;
    }

    public Entity withOnlyPk() {
        Entity copy = new Entity(this.entityType);
        List<EntityPropertyMain> pkProps = this.getPrimaryKey().getKeyProperties();
        for (EntityPropertyMain pkProp : pkProps) {
            copy.setProperty((Property)pkProp, this.getProperty(pkProp));
        }
        copy.setService(this.service);
        return copy;
    }

    public Query query(NavigationPropertyEntitySet navigationPropery) {
        if (this.service == null) {
            throw new IllegalArgumentException("Can not query from an entity not associated with a service.");
        }
        return new Query(this.service, this, navigationPropery);
    }

    public Dao dao(NavigationPropertyEntitySet navigationPropery) {
        if (this.service == null) {
            throw new IllegalArgumentException("Can not query from an entity not associated with a service.");
        }
        return new BaseDao(this.service, this, navigationPropery);
    }

    public MqttSubscription subscribe(Consumer<Entity> handler) throws MqttException {
        this.ensureService();
        String topic = this.service.getServerInfo().getMqttBasePath() + ParserUtils.entityPath(this.entityType, this.getPrimaryKeyValues());
        return this.service.subscribe(topic, handler, this.entityType);
    }

    public MqttSubscription subscribe(NavigationProperty np, Consumer<Entity> handler) throws MqttException {
        this.ensureService();
        String topic = this.service.getServerInfo().getMqttBasePath() + ParserUtils.relationPath(this, np);
        return this.service.subscribe(topic, handler, np.getEntityType());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Entity other = (Entity)obj;
        if (!Objects.equals(this.entityType, other.entityType)) {
            return false;
        }
        return Objects.equals(this.getPrimaryKeyValues(), other.getPrimaryKeyValues());
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + Objects.hashCode(this.entityType);
        hash = 97 * hash + this.getPrimaryKeyValues().hashCode();
        return hash;
    }

    public String display() {
        return this.entityType.display(this);
    }

    public String toString() {
        return this.entityType.toString(this);
    }
}

