/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.json.serialize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import de.fraunhofer.iosb.ilt.frostclient.model.Entity;
import de.fraunhofer.iosb.ilt.frostclient.model.EntitySet;
import de.fraunhofer.iosb.ilt.frostclient.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostclient.model.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationProperty;
import java.io.IOException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitySerializer
extends JsonSerializer<Entity> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)EntitySerializer.class.getName());

    public void serialize(Entity entity, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        try {
            this.writeContent(entity, gen);
        }
        catch (IOException | RuntimeException exc) {
            LOGGER.error("Failed to serialise entity.", (Throwable)exc);
            throw new IOException("could not serialize Entity");
        }
        finally {
            gen.writeEndObject();
        }
    }

    public void writeContent(Entity entity, JsonGenerator gen) throws IOException {
        Set<EntityPropertyMain> entityProps = entity.getEntityType().getEntityProperties();
        Set<NavigationProperty> navigationProps = entity.getEntityType().getNavigationProperties();
        for (EntityPropertyMain ep : entityProps) {
            this.writeEntityProp(ep, entity, gen);
        }
        for (NavigationProperty np : navigationProps) {
            this.writeNavProp(entity, np, gen);
        }
    }

    private void writeEntityProp(EntityPropertyMain ep, Entity entity, JsonGenerator gen) throws IOException {
        if (ep.isReadOnly() && !ep.isKeyPart()) {
            return;
        }
        if (ep == ModelRegistry.EP_SELFLINK) {
            return;
        }
        Object value = entity.getProperty(ep, false);
        if (value != null || entity.isSetProperty(ep)) {
            String name = ep.getName();
            gen.writeObjectField(name, value);
        }
    }

    private void writeNavProp(Entity entity, NavigationProperty np, JsonGenerator gen) throws IOException {
        Object entityOrSet = entity.getProperty(np, false);
        if (entityOrSet instanceof EntitySet) {
            EntitySet entitySet = (EntitySet)entityOrSet;
            this.writeEntitySet(np, entitySet, gen);
        } else if (entityOrSet instanceof Entity) {
            Entity expandedEntity = (Entity)entityOrSet;
            if (expandedEntity.hasService()) {
                gen.writeObjectField(np.getJsonName(), (Object)expandedEntity.withOnlyPk());
            } else {
                gen.writeObjectField(np.getJsonName(), (Object)expandedEntity);
            }
        }
    }

    private void writeEntitySet(NavigationProperty np, EntitySet entitySet, JsonGenerator gen) throws IOException {
        if (entitySet == null || entitySet.isEmpty()) {
            return;
        }
        String jsonName = np.getJsonName();
        gen.writeArrayFieldStart(jsonName);
        for (Entity child : entitySet) {
            gen.writeObject((Object)child);
        }
        gen.writeEndArray();
    }
}

