/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.auth;

import de.fraunhofer.iosb.ilt.configurable.AnnotatedConfigurable;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorPassword;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorString;
import de.fraunhofer.iosb.ilt.frostclient.SensorThingsService;
import de.fraunhofer.iosb.ilt.frostclient.auth.AuthMethod;
import de.fraunhofer.iosb.ilt.frostclient.auth.AuthSettings;
import de.fraunhofer.iosb.ilt.settings.ConfigDefaults;
import de.fraunhofer.iosb.ilt.settings.annotation.DefaultValue;
import de.fraunhofer.iosb.ilt.settings.annotation.SensitiveValue;
import java.io.IOException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthPostCookie
implements AnnotatedConfigurable<Void, Void>,
AuthMethod,
ConfigDefaults {
    public static final String HTTPREQUEST_HEADER_ACCEPT = "Accept";
    public static final String HTTPREQUEST_HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HTTPREQUEST_TYPE_JSON = "application/json";
    @DefaultValue(value="")
    public static final String NAME_VAR_POSTURL = "posturl";
    @DefaultValue(value="")
    public static final String NAME_VAR_USERNAME = "username";
    @DefaultValue(value="")
    @SensitiveValue
    public static final String NAME_VAR_PASSWORD = "password";
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthPostCookie.class);
    @ConfigurableField(editor=EditorString.class, label="PostUrl", description="The url to post to, use placeholders {username} and {password} for username and password.", optional=false)
    @EditorString.EdOptsString(dflt="https://example.org/servlet/is/rest/login?user={username}&key={password}")
    private String postUrl;
    @ConfigurableField(editor=EditorString.class, label="Username", description="The username to use for authentication", optional=false)
    @EditorString.EdOptsString
    private String username;
    @ConfigurableField(editor=EditorPassword.class, label="Password", description="The password to use for authentication", optional=false)
    @EditorPassword.EdOptsPassword
    private String password;

    @Override
    public void setAuth(SensorThingsService service) {
        AuthSettings authSettings = service.getSettings().getAuthSettings();
        if (this.postUrl == null) {
            this.postUrl = authSettings.getSettings().get(NAME_VAR_POSTURL, this.getClass());
            this.username = authSettings.getSettings().get(NAME_VAR_USERNAME, this.getClass());
            this.password = authSettings.getSettings().get(NAME_VAR_PASSWORD, this.getClass());
        }
        String finalUrl = this.postUrl.replace("{username}", this.username);
        finalUrl = finalUrl.replace("{password}", this.password);
        CloseableHttpClient client = service.getHttpClient();
        service.getOrCreateMqttConfig().setAuth(this.username, this.password);
        HttpPost loginPost = new HttpPost(finalUrl);
        loginPost.setHeader(HTTPREQUEST_HEADER_ACCEPT, HTTPREQUEST_TYPE_JSON);
        try {
            client.execute((HttpUriRequest)loginPost);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to login.", (Throwable)ex);
        }
    }
}

