/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.auth;

import de.fraunhofer.iosb.ilt.configurable.AnnotatedConfigurable;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorString;
import de.fraunhofer.iosb.ilt.frostclient.SensorThingsService;
import de.fraunhofer.iosb.ilt.frostclient.auth.AuthMethod;
import de.fraunhofer.iosb.ilt.frostclient.auth.AuthSettings;
import de.fraunhofer.iosb.ilt.frostclient.utils.TokenManager;
import de.fraunhofer.iosb.ilt.settings.ConfigDefaults;
import de.fraunhofer.iosb.ilt.settings.annotation.DefaultValue;
import de.fraunhofer.iosb.ilt.settings.annotation.SensitiveValue;
import org.apache.http.HttpRequest;
import org.apache.http.impl.client.CloseableHttpClient;

public class AuthHeader
implements AnnotatedConfigurable<Void, Void>,
AuthMethod,
ConfigDefaults {
    @DefaultValue(value="")
    public static final String NAME_VAR_HEADERNAME = "headername";
    @DefaultValue(value="")
    @SensitiveValue
    public static final String NAME_VAR_HEADERVALUE = "headervalue";
    @ConfigurableField(editor=EditorString.class, label="Header Name", description="The name of the authentication header to use.")
    @EditorString.EdOptsString
    private String headerName;
    @ConfigurableField(editor=EditorString.class, label="Header Value", description="The value of the authentication header to use.")
    @EditorString.EdOptsString
    private String headerValue;

    @Override
    public void setAuth(SensorThingsService service) {
        AuthSettings authSettings = service.getSettings().getAuthSettings();
        if (this.headerName == null) {
            this.headerName = authSettings.getSettings().get(NAME_VAR_HEADERNAME, this.getClass());
            this.headerValue = authSettings.getSettings().get(NAME_VAR_HEADERVALUE, this.getClass());
        }
        service.setTokenManager(new TokenManager(){

            @Override
            public void addAuthHeader(HttpRequest hr) {
                hr.addHeader(AuthHeader.this.headerName, AuthHeader.this.headerValue);
            }

            public TokenManager setHttpClient(CloseableHttpClient chc) {
                return this;
            }

            @Override
            public CloseableHttpClient getHttpClient() {
                return null;
            }
        });
    }
}

