/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor.swing;

import de.fraunhofer.iosb.ilt.configurable.GuiFactorySwing;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorDouble;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FactoryDoubleSwing
implements GuiFactorySwing {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)FactoryDoubleSwing.class.getName());
    private final EditorDouble parentEditor;
    private JTextField swComponent;

    public FactoryDoubleSwing(EditorDouble parentEditor) {
        this.parentEditor = parentEditor;
    }

    @Override
    public JComponent getComponent() {
        if (this.swComponent == null) {
            this.createComponent();
        }
        return this.swComponent;
    }

    private void createComponent() {
        this.swComponent = new JTextField();
        this.swComponent.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                try {
                    BigDecimal unused = new BigDecimal(((JTextField)input).getText());
                    return true;
                }
                catch (NumberFormatException exc) {
                    LOGGER.trace("Not a decimal.", (Throwable)exc);
                    return false;
                }
            }
        });
        this.swComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FactoryDoubleSwing.this.readComponent();
            }
        });
        this.fillComponent();
    }

    private double getRawValue() {
        Double rawValue = this.parentEditor.getRawValue();
        double min = this.parentEditor.getMin();
        double max = this.parentEditor.getMax();
        if (rawValue == null) {
            rawValue = 0.0;
            this.parentEditor.setRawValue(rawValue);
        }
        if (rawValue < min || rawValue > max) {
            rawValue = Math.max(min, Math.min(rawValue, max));
            this.parentEditor.setRawValue(rawValue);
        }
        return rawValue;
    }

    public void fillComponent() {
        double rawValue = this.getRawValue();
        this.swComponent.setText("" + rawValue);
    }

    public void readComponent() {
        if (this.swComponent != null) {
            try {
                this.parentEditor.setRawValue(Double.parseDouble(this.swComponent.getText()));
            }
            catch (NumberFormatException exc) {
                LOGGER.error("Failed to parse text to number: " + this.swComponent.getText());
            }
            this.fillComponent();
        }
    }
}

