/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor.fx;

import de.fraunhofer.iosb.ilt.configurable.GuiFactoryFx;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorPassword;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorString;
import javafx.scene.Node;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;

public final class FactoryStringFx
implements GuiFactoryFx {
    private final EditorString parentEditor;
    private TextInputControl fxNode;
    private boolean passwordControl;

    public FactoryStringFx(EditorString parentEditor) {
        this.parentEditor = parentEditor;
        if (parentEditor instanceof EditorPassword) {
            this.passwordControl = true;
        }
    }

    @Override
    public Node getNode() {
        if (this.fxNode == null) {
            this.createNode();
        }
        return this.fxNode;
    }

    private void createNode() {
        if (this.passwordControl) {
            this.fxNode = new PasswordField();
        } else if (this.parentEditor.getLines() == 1) {
            this.fxNode = new TextField();
        } else {
            TextArea text = new TextArea();
            text.setPrefRowCount(this.parentEditor.getLines());
            this.fxNode = text;
        }
        this.fillComponent();
    }

    public void fillComponent() {
        this.fxNode.setEditable(this.parentEditor.canEdit());
        String value = this.parentEditor.getRawValue();
        if (value == null) {
            value = "";
        }
        this.fxNode.setText(value);
    }

    public void readComponent() {
        this.parentEditor.setRawValue(this.fxNode.getText());
    }
}

