/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor.fx;

import de.fraunhofer.iosb.ilt.configurable.GuiFactoryFx;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorLong;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FactoryLongFx
implements GuiFactoryFx {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)FactoryLongFx.class.getName());
    private final EditorLong parentEditor;
    private TextInputControl fxNode;

    public FactoryLongFx(EditorLong parentEditor) {
        this.parentEditor = parentEditor;
    }

    @Override
    public Node getNode() {
        if (this.fxNode == null) {
            this.createComponent();
        }
        return this.fxNode;
    }

    private void createComponent() {
        this.fxNode = new TextField();
        this.fillComponent();
    }

    private long getRawValue() {
        Long rawValue = this.parentEditor.getRawValue();
        long min = this.parentEditor.getMin();
        long max = this.parentEditor.getMax();
        if (rawValue == null) {
            rawValue = 0L;
            this.parentEditor.setRawValue(rawValue);
        }
        if (rawValue < min || rawValue > max) {
            rawValue = Math.max(min, Math.min(rawValue, max));
            this.parentEditor.setRawValue(rawValue);
        }
        return rawValue;
    }

    public void fillComponent() {
        long rawValue = this.getRawValue();
        this.fxNode.setText("" + rawValue);
    }

    public void readComponent() {
        if (this.fxNode != null) {
            try {
                this.parentEditor.setRawValue(Long.parseLong(this.fxNode.getText()));
            }
            catch (NumberFormatException exc) {
                LOGGER.error("Failed to parse text to number: " + this.fxNode.getText());
            }
        }
    }
}

