/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import de.fraunhofer.iosb.ilt.configurable.GuiFactoryFx;
import de.fraunhofer.iosb.ilt.configurable.GuiFactorySwing;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.ItemString;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.RootSchema;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.SchemaItem;
import de.fraunhofer.iosb.ilt.configurable.annotations.AnnotationHelper;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorDefault;
import de.fraunhofer.iosb.ilt.configurable.editor.fx.FactoryEnumFx;
import de.fraunhofer.iosb.ilt.configurable.editor.swing.FactoryEnumSwing;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditorEnum<T extends Enum<T>>
extends EditorDefault<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)EditorEnum.class.getName());
    private Class<T> sourceType;
    private T dflt;
    private T value;
    public Set<String> profilesEdit = AnnotationHelper.csvToReadOnlySet("");
    private String profile = "default";
    private FactoryEnumSwing<T> factorySwing;
    private FactoryEnumFx<T> factoryFx;

    public EditorEnum() {
    }

    public EditorEnum(Class<T> sourceType, T deflt, String label, String description) {
        this.sourceType = sourceType;
        this.dflt = deflt;
        this.value = deflt;
        this.setLabel(label);
        this.setDescription(description);
    }

    @Override
    public void initFor(Field field) {
        EdOptsEnum annotation = field.getAnnotation(EdOptsEnum.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Field must have an EdOptsEnum annotation to use this editor: " + field.getName());
        }
        this.sourceType = annotation.sourceType();
        try {
            this.dflt = Enum.valueOf(this.sourceType, annotation.dflt());
        }
        catch (IllegalArgumentException exc) {
            LOGGER.trace("Empty or invalid default: {}", (Object)annotation.dflt(), (Object)exc);
        }
        this.value = this.dflt;
        this.profilesEdit = AnnotationHelper.csvToReadOnlySet(annotation.profilesEdit());
    }

    @Override
    public void setConfig(JsonElement config) {
        if (config != null && config.isJsonPrimitive()) {
            JsonPrimitive prim = config.getAsJsonPrimitive();
            if (prim.isString()) {
                try {
                    this.value = Enum.valueOf(this.sourceType, config.getAsString());
                }
                catch (IllegalArgumentException exc) {
                    this.value = null;
                    LOGGER.trace("Empty or invalid value: {}", (Object)config.getAsString(), (Object)exc);
                }
            } else if (prim.isNumber()) {
                Enum[] list = (Enum[])this.sourceType.getEnumConstants();
                int ord = prim.getAsInt();
                if (ord >= 0 && ord < list.length) {
                    this.value = list[ord];
                }
            }
        } else {
            this.value = this.dflt;
        }
        this.fillComponent();
    }

    @Override
    public JsonElement getConfig() {
        this.readComponent();
        if (this.value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive(((Enum)this.value).name());
    }

    @Override
    public SchemaItem getJsonSchema(RootSchema rootSchema) {
        ItemString item = (ItemString)((ItemString)((ItemString)new ItemString().setTitle(this.getLabel())).setDescription(this.getDescription())).setDeflt(this.dflt);
        for (Enum value : (Enum[])this.sourceType.getEnumConstants()) {
            item.addAllowedValue(value.name());
        }
        if (rootSchema == null) {
            return new RootSchema(item);
        }
        return item;
    }

    @Override
    public GuiFactorySwing getGuiFactorySwing() {
        if (this.factoryFx != null) {
            throw new IllegalArgumentException("Can not mix different types of editors.");
        }
        if (this.factorySwing == null) {
            this.factorySwing = new FactoryEnumSwing(this, this);
        }
        return this.factorySwing;
    }

    @Override
    public GuiFactoryFx getGuiFactoryFx() {
        if (this.factorySwing != null) {
            throw new IllegalArgumentException("Can not mix different types of editors.");
        }
        if (this.factoryFx == null) {
            this.factoryFx = new FactoryEnumFx(this, this);
        }
        return this.factoryFx;
    }

    private void fillComponent() {
        if (this.factorySwing != null) {
            this.factorySwing.fillComponent();
        }
        if (this.factoryFx != null) {
            this.factoryFx.fillComponent();
        }
    }

    private void readComponent() {
        if (this.factorySwing != null) {
            this.factorySwing.readComponent();
        }
        if (this.factoryFx != null) {
            this.factoryFx.readComponent();
        }
    }

    public Class<T> getSourceType() {
        return this.sourceType;
    }

    public T getRawValue() {
        return this.value;
    }

    public void setRawValue(T value) {
        this.value = value;
    }

    @Override
    public T getValue() {
        this.readComponent();
        return this.value;
    }

    @Override
    public T getDefaultValue() {
        return this.dflt;
    }

    @Override
    public void setValue(T value) {
        this.value = value;
        this.fillComponent();
    }

    @Override
    public void setProfile(String profile) {
        this.profile = profile;
        this.fillComponent();
    }

    public void setProfilesEdit(String csv) {
        this.profilesEdit = AnnotationHelper.csvToReadOnlySet(csv);
    }

    @Override
    public boolean canEdit() {
        return this.profilesEdit.contains(this.profile);
    }

    @Override
    public boolean isDefault() {
        this.readComponent();
        return this.dflt == this.value;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface EdOptsEnum {
        public Class<? extends Enum> sourceType();

        public String dflt() default "";

        public String profilesEdit() default "";
    }
}

