/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.JsonSchema;

import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.SchemaItem;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

@JsonAdapter(value=RootSchemaSerialiser.class)
public class RootSchema
implements SchemaItem {
    @SerializedName(value="$schema")
    private String schema = "http://json-schema.org/draft/2019-09/schema#";
    private Map<String, SchemaItem> defs;
    private final SchemaItem wrappedItem;

    public RootSchema(SchemaItem wrappedItem) {
        this.wrappedItem = wrappedItem;
    }

    @Override
    public String getType() {
        return this.wrappedItem.getType();
    }

    public boolean hasDef(String name) {
        return this.defs != null && this.defs.containsKey(name);
    }

    public Map<String, SchemaItem> getDefs() {
        if (this.defs == null) {
            this.defs = new HashMap<String, SchemaItem>();
        }
        return this.defs;
    }

    public void addDef(String name, SchemaItem item) {
        if (this.defs == null) {
            this.defs = new HashMap<String, SchemaItem>();
        }
        this.defs.put(name, item);
    }

    @Override
    public String getTitle() {
        return this.wrappedItem.getTitle();
    }

    @Override
    public RootSchema setTitle(String title) {
        this.wrappedItem.setTitle(title);
        return this;
    }

    @Override
    public String getDescription() {
        return this.wrappedItem.getDescription();
    }

    @Override
    public RootSchema setDescription(String description) {
        this.wrappedItem.setDescription(description);
        return this;
    }

    public String getSchema() {
        return this.schema;
    }

    public static class RootSchemaSerialiser
    implements JsonSerializer<RootSchema> {
        public JsonElement serialize(RootSchema t, Type type, JsonSerializationContext jsc) {
            JsonElement item = jsc.serialize((Object)t.wrappedItem);
            JsonElement defs = jsc.serialize(t.defs);
            item.getAsJsonObject().addProperty("$schema", t.getSchema());
            item.getAsJsonObject().add("definitions", defs);
            return item;
        }
    }
}

