/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core.parser.impl;

import de.focus_shift.jollyday.core.Holiday;
import de.focus_shift.jollyday.core.parser.HolidayParser;
import de.focus_shift.jollyday.core.parser.functions.CreateHoliday;
import de.focus_shift.jollyday.core.parser.functions.FindWeekDayInMonth;
import de.focus_shift.jollyday.core.parser.predicates.ValidLimitation;
import de.focus_shift.jollyday.core.spi.Holidays;
import de.focus_shift.jollyday.core.spi.Relation;
import de.focus_shift.jollyday.core.spi.RelativeToWeekdayInMonth;
import java.time.LocalDate;
import java.time.Year;
import java.util.List;
import java.util.stream.Collectors;

public class RelativeToWeekdayInMonthParser
implements HolidayParser {
    @Override
    public List<Holiday> parse(Year year, Holidays holidays) {
        return holidays.relativeToWeekdayInMonth().stream().filter(new ValidLimitation(year)).map(relativeToWeekdayInMonth -> this.resolveHolidayForRelativeToWeekdayInMonth(year, (RelativeToWeekdayInMonth)relativeToWeekdayInMonth)).collect(Collectors.toList());
    }

    private Holiday resolveHolidayForRelativeToWeekdayInMonth(Year year, RelativeToWeekdayInMonth rwm) {
        LocalDate baseDate = new FindWeekDayInMonth(year).apply(rwm.weekdayInMonth());
        int currentDayValue = baseDate.getDayOfWeek().getValue();
        int targetDayValue = rwm.weekday().getValue();
        int direction = rwm.when() == Relation.BEFORE ? -1 : 1;
        int daysDifference = targetDayValue - currentDayValue;
        if (direction < 0 && daysDifference >= 0) {
            daysDifference -= 7;
        } else if (direction > 0 && daysDifference <= 0) {
            daysDifference += 7;
        }
        LocalDate resultDate = baseDate.plusDays(daysDifference);
        return new CreateHoliday(resultDate).apply(rwm);
    }
}

