/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core.configuration;

import de.focus_shift.jollyday.core.configuration.ConfigurationProvider;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class URLConfigurationProvider
implements ConfigurationProvider {
    static final String CONFIG_URLS_PROPERTY = "de.focus_shift.jollyday.config.urls";
    private static final Logger LOG = LoggerFactory.getLogger(URLConfigurationProvider.class);

    URLConfigurationProvider() {
    }

    @Override
    public Properties getProperties() {
        Properties properties = new Properties();
        String configURLs = System.getProperty(CONFIG_URLS_PROPERTY);
        if (configURLs != null) {
            Arrays.stream(configURLs.split(",")).filter(Predicate.not(String::isEmpty)).map(String::trim).map(this::createUrl).filter(Objects::nonNull).forEach(url -> this.readPropertiesFromURL(properties, (URL)url));
        }
        return properties;
    }

    private void readPropertiesFromURL(Properties properties, URL url) {
        try (InputStream inputStream = url.openStream();){
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not load property from '" + url + "'.", e);
        }
    }

    private URL createUrl(String stringUrl) {
        URL url = null;
        try {
            url = new URL(stringUrl);
        }
        catch (MalformedURLException e) {
            LOG.warn("Cannot read configuration from '{}' with message '{}'.", (Object)stringUrl, (Object)e.getMessage());
        }
        return url;
    }
}

