/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.asmfabricloader.loader;

import java.util.Collection;
import java.util.function.BiConsumer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;

public class AFLFeature {
    public static void applyForMods(Collection<ModContainer> modContainers, String name, BiConsumer<ModContainer, CustomValue> impl) {
        for (ModContainer modContainer : modContainers) {
            CustomValue feature = AFLFeature.getAflFeature(modContainer, name);
            if (feature == null) continue;
            impl.accept(modContainer, feature);
        }
    }

    public static CustomValue getAflFeature(ModContainer modContainer, String name) {
        String env = FabricLoader.getInstance().getEnvironmentType().name().toLowerCase();
        ModMetadata meta = modContainer.getMetadata();
        if (meta.containsCustomValue("afl:" + name)) {
            return meta.getCustomValue("afl:" + name);
        }
        if (meta.containsCustomValue("afl:" + env + ":" + name)) {
            return meta.getCustomValue("afl:" + env + ":" + name);
        }
        return null;
    }
}

