package de.flapdoodle.reverse;

import de.flapdoodle.reflection.TypeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StateID}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStateID.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableStateID.of()}.
 */
@Generated(from = "StateID", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableStateID<T> implements StateID<T> {
  private final String name;
  private final TypeInfo<T> type;

  private ImmutableStateID(String name, TypeInfo<T> type) {
    this.name = Objects.requireNonNull(name, "name");
    this.type = Objects.requireNonNull(type, "type");
  }

  private ImmutableStateID(ImmutableStateID<T> original, String name, TypeInfo<T> type) {
    this.name = name;
    this.type = type;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public TypeInfo<T> type() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StateID#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStateID<T> withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableStateID<>(this, newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StateID#type() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStateID<T> withType(TypeInfo<T> value) {
    if (this.type == value) return this;
    TypeInfo<T> newValue = Objects.requireNonNull(value, "type");
    return new ImmutableStateID<>(this, this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStateID} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStateID<?>
        && equalTo(0, (ImmutableStateID<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableStateID<?> another) {
    return name.equals(another.name)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code StateID} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "StateID{"
        + "name=" + name
        + ", type=" + type
        + "}";
  }

  /**
   * Construct a new immutable {@code StateID} instance.
 * @param <T> generic parameter T
   * @param name The value for the {@code name} attribute
   * @param type The value for the {@code type} attribute
   * @return An immutable StateID instance
   */
  public static <T> ImmutableStateID<T> of(String name, TypeInfo<T> type) {
    return new ImmutableStateID<>(name, type);
  }

  /**
   * Creates an immutable copy of a {@link StateID} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable StateID instance
   */
  public static <T> ImmutableStateID<T> copyOf(StateID<T> instance) {
    if (instance instanceof ImmutableStateID<?>) {
      return (ImmutableStateID<T>) instance;
    }
    return ImmutableStateID.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStateID ImmutableStateID}.
   * <pre>
   * ImmutableStateID.&amp;lt;T&amp;gt;builder()
   *    .name(String) // required {@link StateID#name() name}
   *    .type(de.flapdoodle.reflection.TypeInfo&amp;lt;T&amp;gt;) // required {@link StateID#type() type}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableStateID builder
   */
  public static <T> ImmutableStateID.Builder<T> builder() {
    return new ImmutableStateID.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableStateID ImmutableStateID}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StateID", generator = "Immutables")
  public static final class Builder<T> {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private long initBits = 0x3L;

    private String name;
    private TypeInfo<T> type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code StateID} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(StateID<T> instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.name());
      type(instance.type());
      return this;
    }

    /**
     * Initializes the value for the {@link StateID#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link StateID#type() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> type(TypeInfo<T> type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableStateID ImmutableStateID}.
     * @return An immutable instance of StateID
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStateID<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableStateID<>(null, name, type);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build StateID, some of required attributes are not set " + attributes;
    }
  }
}
