/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embedmongo.config;

import de.flapdoodle.embedmongo.config.ArtifactStoreInUserHome;
import de.flapdoodle.embedmongo.config.IArtifactStoragePathNaming;
import de.flapdoodle.embedmongo.config.MongodProcessOutputConfig;
import de.flapdoodle.embedmongo.extract.ITempNaming;
import de.flapdoodle.embedmongo.extract.UUIDTempNaming;
import de.flapdoodle.embedmongo.output.IProgressListener;
import de.flapdoodle.embedmongo.output.LoggingProgressListener;
import de.flapdoodle.embedmongo.output.StandardConsoleProgressListener;
import de.flapdoodle.embedmongo.runtime.ICommandLinePostProcessor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RuntimeConfig {
    private IProgressListener progressListener = new StandardConsoleProgressListener();
    private String downloadPath = "http://fastdl.mongodb.org/";
    private IArtifactStoragePathNaming artifactStorePath = new ArtifactStoreInUserHome();
    private ITempNaming defaultfileNaming;
    private ITempNaming executableNaming = this.defaultfileNaming = new UUIDTempNaming();
    private MongodProcessOutputConfig mongodOutputConfig = MongodProcessOutputConfig.getDefaultInstance();
    private ICommandLinePostProcessor commandLinePostProcessor = new ICommandLinePostProcessor.Noop();

    public void setDownloadPath(String downloadPath) {
        this.downloadPath = downloadPath;
    }

    public String getDownloadPath() {
        return this.downloadPath;
    }

    public void setProgressListener(IProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public ITempNaming getDefaultfileNaming() {
        return this.defaultfileNaming;
    }

    public void setDefaultfileNaming(ITempNaming defaultfileNaming) {
        this.defaultfileNaming = defaultfileNaming;
    }

    public ITempNaming getExecutableNaming() {
        return this.executableNaming;
    }

    public void setExecutableNaming(ITempNaming executableNaming) {
        this.executableNaming = executableNaming;
    }

    public IProgressListener getProgressListener() {
        return this.progressListener;
    }

    public IArtifactStoragePathNaming getArtifactStorePathNaming() {
        return this.artifactStorePath;
    }

    public void setArtifactStorePathNaming(IArtifactStoragePathNaming value) {
        this.artifactStorePath = value;
    }

    public MongodProcessOutputConfig getMongodOutputConfig() {
        return this.mongodOutputConfig;
    }

    public void setMongodOutputConfig(MongodProcessOutputConfig mongodOutputConfig) {
        this.mongodOutputConfig = mongodOutputConfig;
    }

    public void setCommandLinePostProcessor(ICommandLinePostProcessor commandLinePostProcessor) {
        this.commandLinePostProcessor = commandLinePostProcessor;
    }

    public ICommandLinePostProcessor getCommandLinePostProcessor() {
        return this.commandLinePostProcessor;
    }

    public static RuntimeConfig getInstance(Logger logger) {
        RuntimeConfig ret = new RuntimeConfig();
        ret.setMongodOutputConfig(MongodProcessOutputConfig.getInstance(logger));
        ret.setProgressListener(new LoggingProgressListener(logger, Level.FINE));
        return ret;
    }
}

