/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.io;

import de.flapdoodle.checks.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.stream.Stream;

public abstract class Files {
    private static final int BYTE_BUFFER_LENGTH = 16384;

    private Files() {
    }

    public static void deleteAll(Path rootPath) throws IOException {
        try (Stream<Path> walk = java.nio.file.Files.walk(rootPath, new FileVisitOption[0]);){
            walk.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
    }

    public static boolean isEmptyDirectory(Path directory) throws IOException {
        java.nio.file.Files.isDirectory(directory, new LinkOption[0]);
        Preconditions.checkArgument((boolean)java.nio.file.Files.isDirectory(directory, new LinkOption[0]), (String)"Is not a directory %s", (Object[])new Object[]{directory});
        Preconditions.checkArgument((boolean)java.nio.file.Files.exists(directory, new LinkOption[0]), (String)"directory %s does not exist", (Object[])new Object[]{directory});
        try (Stream<Path> list = java.nio.file.Files.list(directory);){
            boolean bl = !list.findAny().isPresent();
            return bl;
        }
    }

    public static void write(InputStream inputStream, long size, Path destination) throws IOException {
        try (OutputStream out = java.nio.file.Files.newOutputStream(destination, new OpenOption[0]);){
            int read;
            byte[] buf = new byte[16384];
            int left = buf.length;
            if ((long)left > size) {
                left = (int)size;
            }
            while ((read = inputStream.read(buf, 0, left)) > 0) {
                out.write(buf, 0, read);
                if ((long)left <= (size -= (long)read)) continue;
                left = (int)size;
            }
        }
    }
}

