/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.store;

import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.extract.ExtractedFileSet;
import de.flapdoodle.embed.process.runtime.ProcessControl;
import de.flapdoodle.embed.process.store.IArtifactStore;
import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingArtifactStore
implements IArtifactStore {
    private static final Logger logger = LoggerFactory.getLogger(CachingArtifactStore.class);
    private final IArtifactStore delegate;
    private final Object lock = new Object();
    private final HashMap<Distribution, FilesWithCounter> distributionFiles = new HashMap();
    private final ScheduledExecutorService executor;

    public CachingArtifactStore(IArtifactStore delegate) {
        this.delegate = delegate;
        ProcessControl.addShutdownHook(new CacheCleaner());
        this.executor = Executors.newSingleThreadScheduledExecutor(new CustomThreadFactory());
        this.executor.scheduleAtFixedRate(new RemoveUnused(), 10L, 10L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<ExtractedFileSet> extractFileSet(Distribution distribution) throws IOException {
        FilesWithCounter fileWithCounter;
        Object object = this.lock;
        synchronized (object) {
            fileWithCounter = this.distributionFiles.get(distribution);
            if (fileWithCounter == null) {
                logger.debug("cache NOT found for {}", (Object)distribution);
                fileWithCounter = new FilesWithCounter(distribution);
                this.distributionFiles.put(distribution, fileWithCounter);
            } else {
                logger.debug("cache found for {}", (Object)distribution);
            }
        }
        return fileWithCounter.use();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFileSet(Distribution distribution, ExtractedFileSet executable) {
        FilesWithCounter fileWithCounter;
        Object object = this.lock;
        synchronized (object) {
            fileWithCounter = this.distributionFiles.get(distribution);
        }
        if (fileWithCounter != null) {
            fileWithCounter.free(executable);
        } else {
            logger.warn("Already removed {} for {}, emergency shutdown?", (Object)executable, (Object)distribution);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAll() {
        Object object = this.lock;
        synchronized (object) {
            for (FilesWithCounter fc : this.distributionFiles.values()) {
                fc.forceDelete();
            }
            this.distributionFiles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUnused() {
        Object object = this.lock;
        synchronized (object) {
            for (FilesWithCounter fc : this.distributionFiles.values()) {
                fc.cleanup();
            }
        }
    }

    protected void shutdownExecutor() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                for (Runnable r : this.executor.shutdownNow()) {
                    logger.warn("Terminated job of type {}", (Object)r.getClass().getName());
                }
                if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                    logger.error("Executor did not terminate.");
                }
            }
            if (!this.executor.isShutdown()) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException ie) {
            this.executor.shutdownNow();
        }
    }

    class CustomThreadFactory
    implements ThreadFactory {
        private final ThreadFactory factory = Executors.defaultThreadFactory();

        CustomThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread ret = this.factory.newThread(runnable);
            ret.setDaemon(true);
            return ret;
        }
    }

    class CacheCleaner
    implements Runnable {
        CacheCleaner() {
        }

        @Override
        public void run() {
            CachingArtifactStore.this.removeAll();
            CachingArtifactStore.this.shutdownExecutor();
        }
    }

    class RemoveUnused
    implements Runnable {
        RemoveUnused() {
        }

        @Override
        public void run() {
            CachingArtifactStore.this.removeUnused();
        }
    }

    class FilesWithCounter {
        private Optional<ExtractedFileSet> file;
        private int counter = 0;
        private final Distribution distribution;

        public FilesWithCounter(Distribution distribution) {
            this.distribution = distribution;
        }

        public synchronized void free(ExtractedFileSet executable) {
            if (this.file == null) {
                throw new RuntimeException("nothing to free");
            }
            if (executable != this.file.orElse(null)) {
                throw new RuntimeException("Files does not match: " + this.file + " != " + executable);
            }
            logger.debug("Free {} {}", (Object)this.counter, this.file);
            --this.counter;
        }

        public synchronized Optional<ExtractedFileSet> use() throws IOException {
            ++this.counter;
            if (this.file == null) {
                this.file = CachingArtifactStore.this.delegate.extractFileSet(this.distribution);
                logger.debug("Not Cached {} {}", (Object)this.counter, this.file);
            } else {
                logger.debug("Cached {} {}", (Object)this.counter, this.file);
            }
            return this.file;
        }

        public synchronized void cleanup() {
            if (this.counter <= 0) {
                if (this.counter < 0) {
                    logger.warn("Counter < 0 for {} and {}", (Object)this.distribution, this.file);
                }
                if (this.file != null) {
                    logger.debug("cleanup for {} and {}", (Object)this.distribution, this.file);
                    if (this.file.isPresent()) {
                        CachingArtifactStore.this.delegate.removeFileSet(this.distribution, this.file.get());
                    }
                    this.file = null;
                }
            }
        }

        public synchronized void forceDelete() {
            if (this.file != null) {
                logger.debug("force delete for {} and {}", (Object)this.distribution, this.file);
                if (this.file.isPresent()) {
                    CachingArtifactStore.this.delegate.removeFileSet(this.distribution, this.file.get());
                }
                this.file = null;
                this.counter = 0;
            }
        }
    }
}

