/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.distribution;

import de.flapdoodle.embed.process.distribution.BitSize;
import de.flapdoodle.embed.process.distribution.ImmutableDistribution;
import de.flapdoodle.embed.process.distribution.Platform;
import de.flapdoodle.embed.process.distribution.Version;
import org.immutables.value.Value;

@Value.Immutable
public abstract class Distribution {
    @Value.Parameter
    public abstract Version version();

    @Value.Parameter
    public abstract Platform platform();

    @Value.Parameter
    public abstract BitSize bitsize();

    public String toString() {
        return "" + this.version() + ":" + (Object)((Object)this.platform()) + ":" + (Object)((Object)this.bitsize());
    }

    public static Distribution detectFor(Version version) {
        return Distribution.of(version, Platform.detect(), BitSize.detect());
    }

    public static Distribution of(Version version, Platform platform, BitSize bitsize) {
        return ImmutableDistribution.of(version, platform, bitsize);
    }
}

