/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.extract;

import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImmutableExtractedFileSet
implements IExtractedFileSet {
    private final File _executable;
    private final Map<FileType, List<File>> _files;
    private final File _generatedBaseDir;

    ImmutableExtractedFileSet(File generatedBaseDir, File executable, Map<FileType, List<File>> files) {
        if (executable == null) {
            throw new NullPointerException("executable is NULL");
        }
        if (files == null) {
            throw new NullPointerException("files is NULL");
        }
        this._generatedBaseDir = generatedBaseDir;
        this._executable = executable;
        HashMap copy = new HashMap();
        for (FileType key : files.keySet()) {
            copy.put(key, Collections.unmodifiableList(new ArrayList(files.get((Object)key))));
        }
        this._files = Collections.unmodifiableMap(copy);
    }

    @Override
    public File generatedBaseDir() {
        return this._generatedBaseDir;
    }

    @Override
    public File executable() {
        return this._executable;
    }

    @Override
    public List<File> files(FileType type) {
        List<File> ret = this._files.get((Object)type);
        if (ret == null) {
            ret = Collections.emptyList();
        }
        return ret;
    }

    public static Builder builder(File generatedBaseDir) {
        return new Builder().setGeneratedBaseDir(generatedBaseDir);
    }

    public static class Builder {
        File _executable = null;
        File _generatedBaseDir = null;
        Map<FileType, List<File>> _files = new HashMap<FileType, List<File>>();

        public Builder executable(File executable) {
            if (this._executable != null) {
                throw new IllegalArgumentException("executable allready set to " + this._executable);
            }
            this._executable = executable;
            return this;
        }

        public Builder setGeneratedBaseDir(File generatedBaseDir) {
            this._generatedBaseDir = generatedBaseDir;
            return this;
        }

        public Builder file(FileType type, File file) {
            if (type == FileType.Executable) {
                return this.executable(file);
            }
            List<File> collection = this._files.get((Object)type);
            if (collection == null) {
                collection = new ArrayList<File>();
                this._files.put(type, collection);
            }
            collection.add(file);
            return this;
        }

        public IExtractedFileSet build() {
            return new ImmutableExtractedFileSet(this._generatedBaseDir, this._executable, this._files);
        }
    }
}

