/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.commands;

import de.flapdoodle.embed.mongo.commands.MongoDumpArguments;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public final class ImmutableMongoDumpArguments
extends MongoDumpArguments {
    private final boolean verbose;
    private final String databaseName;
    private final String collectionName;
    private final String query;
    private final String queryFile;
    private final String readPreference;
    private final boolean forceTableScan;
    private final String archive;
    private final boolean dumpDbUsersAndRoles;
    private final boolean gzip;
    private final boolean repair;
    private final String dir;
    private final boolean isOplog;
    private final String excludeCollection;
    private final String excludeCollectionWithPrefix;
    private final Integer numberOfParallelCollections;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMongoDumpArguments(Builder builder) {
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.query = builder.query;
        this.queryFile = builder.queryFile;
        this.readPreference = builder.readPreference;
        this.archive = builder.archive;
        this.dir = builder.dir;
        this.excludeCollection = builder.excludeCollection;
        this.excludeCollectionWithPrefix = builder.excludeCollectionWithPrefix;
        this.numberOfParallelCollections = builder.numberOfParallelCollections;
        if (builder.verboseIsSet()) {
            this.initShim.verbose(builder.verbose);
        }
        if (builder.forceTableScanIsSet()) {
            this.initShim.forceTableScan(builder.forceTableScan);
        }
        if (builder.dumpDbUsersAndRolesIsSet()) {
            this.initShim.dumpDbUsersAndRoles(builder.dumpDbUsersAndRoles);
        }
        if (builder.gzipIsSet()) {
            this.initShim.gzip(builder.gzip);
        }
        if (builder.repairIsSet()) {
            this.initShim.repair(builder.repair);
        }
        if (builder.isOplogIsSet()) {
            this.initShim.isOplog(builder.isOplog);
        }
        this.verbose = this.initShim.verbose();
        this.forceTableScan = this.initShim.forceTableScan();
        this.dumpDbUsersAndRoles = this.initShim.dumpDbUsersAndRoles();
        this.gzip = this.initShim.gzip();
        this.repair = this.initShim.repair();
        this.isOplog = this.initShim.isOplog();
        this.initShim = null;
    }

    private ImmutableMongoDumpArguments(boolean verbose, String databaseName, String collectionName, String query, String queryFile, String readPreference, boolean forceTableScan, String archive, boolean dumpDbUsersAndRoles, boolean gzip, boolean repair, String dir, boolean isOplog, String excludeCollection, String excludeCollectionWithPrefix, Integer numberOfParallelCollections) {
        this.verbose = verbose;
        this.databaseName = databaseName;
        this.collectionName = collectionName;
        this.query = query;
        this.queryFile = queryFile;
        this.readPreference = readPreference;
        this.forceTableScan = forceTableScan;
        this.archive = archive;
        this.dumpDbUsersAndRoles = dumpDbUsersAndRoles;
        this.gzip = gzip;
        this.repair = repair;
        this.dir = dir;
        this.isOplog = isOplog;
        this.excludeCollection = excludeCollection;
        this.excludeCollectionWithPrefix = excludeCollectionWithPrefix;
        this.numberOfParallelCollections = numberOfParallelCollections;
        this.initShim = null;
    }

    @Override
    public boolean verbose() {
        InitShim shim = this.initShim;
        return shim != null ? shim.verbose() : this.verbose;
    }

    @Override
    public Optional<String> databaseName() {
        return Optional.ofNullable(this.databaseName);
    }

    @Override
    public Optional<String> collectionName() {
        return Optional.ofNullable(this.collectionName);
    }

    @Override
    public Optional<String> query() {
        return Optional.ofNullable(this.query);
    }

    @Override
    public Optional<String> queryFile() {
        return Optional.ofNullable(this.queryFile);
    }

    @Override
    public Optional<String> readPreference() {
        return Optional.ofNullable(this.readPreference);
    }

    @Override
    public boolean forceTableScan() {
        InitShim shim = this.initShim;
        return shim != null ? shim.forceTableScan() : this.forceTableScan;
    }

    @Override
    public Optional<String> archive() {
        return Optional.ofNullable(this.archive);
    }

    @Override
    public boolean dumpDbUsersAndRoles() {
        InitShim shim = this.initShim;
        return shim != null ? shim.dumpDbUsersAndRoles() : this.dumpDbUsersAndRoles;
    }

    @Override
    public boolean gzip() {
        InitShim shim = this.initShim;
        return shim != null ? shim.gzip() : this.gzip;
    }

    @Override
    public boolean repair() {
        InitShim shim = this.initShim;
        return shim != null ? shim.repair() : this.repair;
    }

    @Override
    public Optional<String> dir() {
        return Optional.ofNullable(this.dir);
    }

    @Override
    public boolean isOplog() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isOplog() : this.isOplog;
    }

    @Override
    public Optional<String> excludeCollection() {
        return Optional.ofNullable(this.excludeCollection);
    }

    @Override
    public Optional<String> excludeCollectionWithPrefix() {
        return Optional.ofNullable(this.excludeCollectionWithPrefix);
    }

    @Override
    public OptionalInt numberOfParallelCollections() {
        return this.numberOfParallelCollections != null ? OptionalInt.of(this.numberOfParallelCollections) : OptionalInt.empty();
    }

    public final ImmutableMongoDumpArguments withVerbose(boolean value) {
        if (this.verbose == value) {
            return this;
        }
        return new ImmutableMongoDumpArguments(value, this.databaseName, this.collectionName, this.query, this.queryFile, this.readPreference, this.forceTableScan, this.archive, this.dumpDbUsersAndRoles, this.gzip, this.repair, this.dir, this.isOplog, this.excludeCollection, this.excludeCollectionWithPrefix, this.numberOfParallelCollections);
    }

    public final ImmutableMongoDumpArguments withDatabaseName(String value) {
        String newValue = Objects.requireNonNull(value, "databaseName");
        if (Objects.equals(this.databaseName, newValue)) {
            return this;
        }
        return new ImmutableMongoDumpArguments(this.verbose, newValue, this.collectionName, this.query, this.queryFile, this.readPreference, this.forceTableScan, this.archive, this.dumpDbUsersAndRoles, this.gzip, this.repair, this.dir, this.isOplog, this.excludeCollection, this.excludeCollectionWithPrefix, this.numberOfParallelCollections);
    }

    public final ImmutableMongoDumpArguments withDatabaseName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.databaseName, value)) {
            return this;
        }
        return new ImmutableMongoDumpArguments(this.verbose, value, this.collectionName, this.query, this.queryFile, this.readPreference, this.forceTableScan, this.archive, this.dumpDbUsersAndRoles, this.gzip, this.repair, this.dir, this.isOplog, this.excludeCollection, this.excludeCollectionWithPrefix, this.numberOfParallelCollections);
    }

    public final ImmutableMongoDumpArguments withCollectionName(String value) {
        String newValue = Objects.requireNonNull(value, "collectionName");
        if (Objects.equals(this.collectionName, newValue)) {
            return this;
        }
        return new ImmutableMongoDumpArguments(this.verbose, this.databaseName, newValue, this.query, this.queryFile, this.readPreference, this.forceTableScan, this.archive, this.dumpDbUsersAndRoles, this.gzip, this.repair, this.dir, this.isOplog, this.excludeCollection, this.excludeCollectionWithPrefix, this.numberOfParallelCollections);
    }

    public final ImmutableMongoDumpArguments withCollectionName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.collectionName, value)) {
            return this;
        }
        return new ImmutableMongoDumpArguments(this.verbose, this.databaseName, value, this.query, this.queryFile, this.readPreference, this.forceTableScan, this.archive, this.dumpDbUsersAndRoles, this.gzip, this.repair, this.dir, this.isOplog, this.excludeCollection, this.excludeCollectionWithPrefix, this.numberOfParallelCollections);
    }

    public final ImmutableMongoDumpArguments withQuery(String value) {
        String newValue = Objects.requireNonNull(value, "query");
        if (Objects.equals(this.query, newValue)) {
            return this;
        }
        return new ImmutableMongoDumpArguments(this.verbose, this.databaseName, this.collectionName, newValue, this.queryFile, this.readPreference, this.forceTableScan, this.archive, this.dumpDbUsersAndRoles, this.gzip, this.repair, this.dir, this.isOplog, this.excludeCollection, this.excludeCollectionWithPrefix, this.numberOfParallelCollections);
    }

    public final ImmutableMongoDumpArguments withQuery(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.query, value)) {
            return this;
        }
        return new ImmutableMongoDumpArguments(this.verbose, this.databaseName, this.collectionName, value, this.queryFile, this.readPreference, this.forceTableScan, this.archive, this.dumpDbUsersAndRoles, this.gzip, this.repair, this.dir, this.isOplog, this.excludeCollection, this.excludeCollectionWithPrefix, this.numberOfParallelCollections);
    }

    public final ImmutableMongoDumpArguments withQueryFile(String value) {
        String newValue = Objects.requireNonNull(value, "queryFile");
        if (Objects.equals(this.queryFile, newValue)) {
            return this;
        }
        return new ImmutableMongoDumpArguments(this.verbose, this.databaseName, this.collectionName, this.query, newValue, this.readPreference, this.forceTableScan, this.archive, this.dumpDbUsersAndRoles, this.gzip, this.repair, this.dir, this.isOplog, this.excludeCollection, this.excludeCollectionWithPrefix, this.numberOfParallelCollections);
    }

    public final ImmutableMongoDumpArguments withQueryFile(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.queryFile, value)) {
            return this;
        }
        return new ImmutableMongoDumpArguments(this.verbose, this.databaseName, this.collectionName, this.query, value, this.readPreference, this.forceTableScan, this.archive, this.dumpDbUsersAndRoles, this.gzip, this.repair, this.dir, this.isOplog, this.excludeCollection, this.excludeCollectionWithPrefix, this.numberOfParallelCollections);
    }

    public final ImmutableMongoDumpArguments withReadPreference(String value) {
        String newValue = Objects.requireNonNull(value, "readPreference");
        if (Objects.equals(this.readPreference, newValue)) {
            return this;
        }
        return new ImmutableMongoDumpArguments(this.verbose, this.databaseName, this.collectionName, this.query, this.queryFile, newValue, this.forceTableScan, this.archive, this.dumpDbUsersAndRoles, this.gzip, this.repair, this.dir, this.isOplog, this.excludeCollection, this.excludeCollectionWithPrefix, this.numberOfParallelCollections);
    }

    public final ImmutableMongoDumpArguments withReadPreference(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.readPreference, value)) {
            return this;
        }
        return new ImmutableMongoDumpArguments(this.verbose, this.databaseName, this.collectionName, this.query, this.queryFile, value, this.forceTableScan, this.archive, this.dumpDbUsersAndRoles, this.gzip, this.repair, this.dir, this.isOplog, this.excludeCollection, this.excludeCollectionWithPrefix, this.numberOfParallelCollections);
    }

    public final ImmutableMongoDumpArguments withForceTableScan(boolean value) {
        if (this.forceTableScan == value) {
            return this;
        }
        return new ImmutableMongoDumpArguments(this.verbose, this.databaseName, this.collectionName, this.query, this.queryFile, this.readPreference, value, this.archive, this.dumpDbUsersAndRoles, this.gzip, this.repair, this.dir, this.isOplog, this.excludeCollection, this.excludeCollectionWithPrefix, this.numberOfParallelCollections);
    }

    public final ImmutableMongoDumpArguments withArchive(String value) {
        String newValue = Objects.requireNonNull(value, "archive");
        if (Objects.equals(this.archive, newValue)) {
            return this;
        }
        return new ImmutableMongoDumpArguments(this.verbose, this.databaseName, this.collectionName, this.query, this.queryFile, this.readPreference, this.forceTableScan, newValue, this.dumpDbUsersAndRoles, this.gzip, this.repair, this.dir, this.isOplog, this.excludeCollection, this.excludeCollectionWithPrefix, this.numberOfParallelCollections);
    }

    public final ImmutableMongoDumpArguments withArchive(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.archive, value)) {
            return this;
        }
        return new ImmutableMongoDumpArguments(this.verbose, this.databaseName, this.collectionName, this.query, this.queryFile, this.readPreference, this.forceTableScan, value, this.dumpDbUsersAndRoles, this.gzip, this.repair, this.dir, this.isOplog, this.excludeCollection, this.excludeCollectionWithPrefix, this.numberOfParallelCollections);
    }

    public final ImmutableMongoDumpArguments withDumpDbUsersAndRoles(boolean value) {
        if (this.dumpDbUsersAndRoles == value) {
            return this;
        }
        return new ImmutableMongoDumpArguments(this.verbose, this.databaseName, this.collectionName, this.query, this.queryFile, this.readPreference, this.forceTableScan, this.archive, value, this.gzip, this.repair, this.dir, this.isOplog, this.excludeCollection, this.excludeCollectionWithPrefix, this.numberOfParallelCollections);
    }

    public final ImmutableMongoDumpArguments withGzip(boolean value) {
        if (this.gzip == value) {
            return this;
        }
        return new ImmutableMongoDumpArguments(this.verbose, this.databaseName, this.collectionName, this.query, this.queryFile, this.readPreference, this.forceTableScan, this.archive, this.dumpDbUsersAndRoles, value, this.repair, this.dir, this.isOplog, this.excludeCollection, this.excludeCollectionWithPrefix, this.numberOfParallelCollections);
    }

    public final ImmutableMongoDumpArguments withRepair(boolean value) {
        if (this.repair == value) {
            return this;
        }
        return new ImmutableMongoDumpArguments(this.verbose, this.databaseName, this.collectionName, this.query, this.queryFile, this.readPreference, this.forceTableScan, this.archive, this.dumpDbUsersAndRoles, this.gzip, value, this.dir, this.isOplog, this.excludeCollection, this.excludeCollectionWithPrefix, this.numberOfParallelCollections);
    }

    public final ImmutableMongoDumpArguments withDir(String value) {
        String newValue = Objects.requireNonNull(value, "dir");
        if (Objects.equals(this.dir, newValue)) {
            return this;
        }
        return new ImmutableMongoDumpArguments(this.verbose, this.databaseName, this.collectionName, this.query, this.queryFile, this.readPreference, this.forceTableScan, this.archive, this.dumpDbUsersAndRoles, this.gzip, this.repair, newValue, this.isOplog, this.excludeCollection, this.excludeCollectionWithPrefix, this.numberOfParallelCollections);
    }

    public final ImmutableMongoDumpArguments withDir(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.dir, value)) {
            return this;
        }
        return new ImmutableMongoDumpArguments(this.verbose, this.databaseName, this.collectionName, this.query, this.queryFile, this.readPreference, this.forceTableScan, this.archive, this.dumpDbUsersAndRoles, this.gzip, this.repair, value, this.isOplog, this.excludeCollection, this.excludeCollectionWithPrefix, this.numberOfParallelCollections);
    }

    public final ImmutableMongoDumpArguments withIsOplog(boolean value) {
        if (this.isOplog == value) {
            return this;
        }
        return new ImmutableMongoDumpArguments(this.verbose, this.databaseName, this.collectionName, this.query, this.queryFile, this.readPreference, this.forceTableScan, this.archive, this.dumpDbUsersAndRoles, this.gzip, this.repair, this.dir, value, this.excludeCollection, this.excludeCollectionWithPrefix, this.numberOfParallelCollections);
    }

    public final ImmutableMongoDumpArguments withExcludeCollection(String value) {
        String newValue = Objects.requireNonNull(value, "excludeCollection");
        if (Objects.equals(this.excludeCollection, newValue)) {
            return this;
        }
        return new ImmutableMongoDumpArguments(this.verbose, this.databaseName, this.collectionName, this.query, this.queryFile, this.readPreference, this.forceTableScan, this.archive, this.dumpDbUsersAndRoles, this.gzip, this.repair, this.dir, this.isOplog, newValue, this.excludeCollectionWithPrefix, this.numberOfParallelCollections);
    }

    public final ImmutableMongoDumpArguments withExcludeCollection(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.excludeCollection, value)) {
            return this;
        }
        return new ImmutableMongoDumpArguments(this.verbose, this.databaseName, this.collectionName, this.query, this.queryFile, this.readPreference, this.forceTableScan, this.archive, this.dumpDbUsersAndRoles, this.gzip, this.repair, this.dir, this.isOplog, value, this.excludeCollectionWithPrefix, this.numberOfParallelCollections);
    }

    public final ImmutableMongoDumpArguments withExcludeCollectionWithPrefix(String value) {
        String newValue = Objects.requireNonNull(value, "excludeCollectionWithPrefix");
        if (Objects.equals(this.excludeCollectionWithPrefix, newValue)) {
            return this;
        }
        return new ImmutableMongoDumpArguments(this.verbose, this.databaseName, this.collectionName, this.query, this.queryFile, this.readPreference, this.forceTableScan, this.archive, this.dumpDbUsersAndRoles, this.gzip, this.repair, this.dir, this.isOplog, this.excludeCollection, newValue, this.numberOfParallelCollections);
    }

    public final ImmutableMongoDumpArguments withExcludeCollectionWithPrefix(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.excludeCollectionWithPrefix, value)) {
            return this;
        }
        return new ImmutableMongoDumpArguments(this.verbose, this.databaseName, this.collectionName, this.query, this.queryFile, this.readPreference, this.forceTableScan, this.archive, this.dumpDbUsersAndRoles, this.gzip, this.repair, this.dir, this.isOplog, this.excludeCollection, value, this.numberOfParallelCollections);
    }

    public final ImmutableMongoDumpArguments withNumberOfParallelCollections(int value) {
        Integer newValue = value;
        if (Objects.equals(this.numberOfParallelCollections, newValue)) {
            return this;
        }
        return new ImmutableMongoDumpArguments(this.verbose, this.databaseName, this.collectionName, this.query, this.queryFile, this.readPreference, this.forceTableScan, this.archive, this.dumpDbUsersAndRoles, this.gzip, this.repair, this.dir, this.isOplog, this.excludeCollection, this.excludeCollectionWithPrefix, newValue);
    }

    public final ImmutableMongoDumpArguments withNumberOfParallelCollections(OptionalInt optional) {
        Integer value;
        Integer n = value = optional.isPresent() ? Integer.valueOf(optional.getAsInt()) : null;
        if (Objects.equals(this.numberOfParallelCollections, value)) {
            return this;
        }
        return new ImmutableMongoDumpArguments(this.verbose, this.databaseName, this.collectionName, this.query, this.queryFile, this.readPreference, this.forceTableScan, this.archive, this.dumpDbUsersAndRoles, this.gzip, this.repair, this.dir, this.isOplog, this.excludeCollection, this.excludeCollectionWithPrefix, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMongoDumpArguments && this.equalsByValue((ImmutableMongoDumpArguments)another);
    }

    private boolean equalsByValue(ImmutableMongoDumpArguments another) {
        return this.verbose == another.verbose && Objects.equals(this.databaseName, another.databaseName) && Objects.equals(this.collectionName, another.collectionName) && Objects.equals(this.query, another.query) && Objects.equals(this.queryFile, another.queryFile) && Objects.equals(this.readPreference, another.readPreference) && this.forceTableScan == another.forceTableScan && Objects.equals(this.archive, another.archive) && this.dumpDbUsersAndRoles == another.dumpDbUsersAndRoles && this.gzip == another.gzip && this.repair == another.repair && Objects.equals(this.dir, another.dir) && this.isOplog == another.isOplog && Objects.equals(this.excludeCollection, another.excludeCollection) && Objects.equals(this.excludeCollectionWithPrefix, another.excludeCollectionWithPrefix) && Objects.equals(this.numberOfParallelCollections, another.numberOfParallelCollections);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.verbose);
        h += (h << 5) + Objects.hashCode(this.databaseName);
        h += (h << 5) + Objects.hashCode(this.collectionName);
        h += (h << 5) + Objects.hashCode(this.query);
        h += (h << 5) + Objects.hashCode(this.queryFile);
        h += (h << 5) + Objects.hashCode(this.readPreference);
        h += (h << 5) + Boolean.hashCode(this.forceTableScan);
        h += (h << 5) + Objects.hashCode(this.archive);
        h += (h << 5) + Boolean.hashCode(this.dumpDbUsersAndRoles);
        h += (h << 5) + Boolean.hashCode(this.gzip);
        h += (h << 5) + Boolean.hashCode(this.repair);
        h += (h << 5) + Objects.hashCode(this.dir);
        h += (h << 5) + Boolean.hashCode(this.isOplog);
        h += (h << 5) + Objects.hashCode(this.excludeCollection);
        h += (h << 5) + Objects.hashCode(this.excludeCollectionWithPrefix);
        h += (h << 5) + Objects.hashCode(this.numberOfParallelCollections);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("MongoDumpArguments{");
        builder.append("verbose=").append(this.verbose);
        if (this.databaseName != null) {
            builder.append(", ");
            builder.append("databaseName=").append(this.databaseName);
        }
        if (this.collectionName != null) {
            builder.append(", ");
            builder.append("collectionName=").append(this.collectionName);
        }
        if (this.query != null) {
            builder.append(", ");
            builder.append("query=").append(this.query);
        }
        if (this.queryFile != null) {
            builder.append(", ");
            builder.append("queryFile=").append(this.queryFile);
        }
        if (this.readPreference != null) {
            builder.append(", ");
            builder.append("readPreference=").append(this.readPreference);
        }
        builder.append(", ");
        builder.append("forceTableScan=").append(this.forceTableScan);
        if (this.archive != null) {
            builder.append(", ");
            builder.append("archive=").append(this.archive);
        }
        builder.append(", ");
        builder.append("dumpDbUsersAndRoles=").append(this.dumpDbUsersAndRoles);
        builder.append(", ");
        builder.append("gzip=").append(this.gzip);
        builder.append(", ");
        builder.append("repair=").append(this.repair);
        if (this.dir != null) {
            builder.append(", ");
            builder.append("dir=").append(this.dir);
        }
        builder.append(", ");
        builder.append("isOplog=").append(this.isOplog);
        if (this.excludeCollection != null) {
            builder.append(", ");
            builder.append("excludeCollection=").append(this.excludeCollection);
        }
        if (this.excludeCollectionWithPrefix != null) {
            builder.append(", ");
            builder.append("excludeCollectionWithPrefix=").append(this.excludeCollectionWithPrefix);
        }
        if (this.numberOfParallelCollections != null) {
            builder.append(", ");
            builder.append("numberOfParallelCollections=").append(this.numberOfParallelCollections);
        }
        return builder.append("}").toString();
    }

    public static ImmutableMongoDumpArguments copyOf(MongoDumpArguments instance) {
        if (instance instanceof ImmutableMongoDumpArguments) {
            return (ImmutableMongoDumpArguments)instance;
        }
        return ImmutableMongoDumpArguments.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_VERBOSE = 1L;
        private static final long OPT_BIT_FORCE_TABLE_SCAN = 2L;
        private static final long OPT_BIT_DUMP_DB_USERS_AND_ROLES = 4L;
        private static final long OPT_BIT_GZIP = 8L;
        private static final long OPT_BIT_REPAIR = 16L;
        private static final long OPT_BIT_IS_OPLOG = 32L;
        private long optBits;
        private boolean verbose;
        private String databaseName;
        private String collectionName;
        private String query;
        private String queryFile;
        private String readPreference;
        private boolean forceTableScan;
        private String archive;
        private boolean dumpDbUsersAndRoles;
        private boolean gzip;
        private boolean repair;
        private String dir;
        private boolean isOplog;
        private String excludeCollection;
        private String excludeCollectionWithPrefix;
        private Integer numberOfParallelCollections;

        private Builder() {
        }

        public final Builder from(MongoDumpArguments instance) {
            OptionalInt numberOfParallelCollectionsOptional;
            Optional<String> excludeCollectionWithPrefixOptional;
            Optional<String> readPreferenceOptional;
            Optional<String> queryFileOptional;
            Optional<String> queryOptional;
            Optional<String> collectionNameOptional;
            Objects.requireNonNull(instance, "instance");
            this.verbose(instance.verbose());
            Optional<String> databaseNameOptional = instance.databaseName();
            if (databaseNameOptional.isPresent()) {
                this.databaseName(databaseNameOptional);
            }
            if ((collectionNameOptional = instance.collectionName()).isPresent()) {
                this.collectionName(collectionNameOptional);
            }
            if ((queryOptional = instance.query()).isPresent()) {
                this.query(queryOptional);
            }
            if ((queryFileOptional = instance.queryFile()).isPresent()) {
                this.queryFile(queryFileOptional);
            }
            if ((readPreferenceOptional = instance.readPreference()).isPresent()) {
                this.readPreference(readPreferenceOptional);
            }
            this.forceTableScan(instance.forceTableScan());
            Optional<String> archiveOptional = instance.archive();
            if (archiveOptional.isPresent()) {
                this.archive(archiveOptional);
            }
            this.dumpDbUsersAndRoles(instance.dumpDbUsersAndRoles());
            this.gzip(instance.gzip());
            this.repair(instance.repair());
            Optional<String> dirOptional = instance.dir();
            if (dirOptional.isPresent()) {
                this.dir(dirOptional);
            }
            this.isOplog(instance.isOplog());
            Optional<String> excludeCollectionOptional = instance.excludeCollection();
            if (excludeCollectionOptional.isPresent()) {
                this.excludeCollection(excludeCollectionOptional);
            }
            if ((excludeCollectionWithPrefixOptional = instance.excludeCollectionWithPrefix()).isPresent()) {
                this.excludeCollectionWithPrefix(excludeCollectionWithPrefixOptional);
            }
            if ((numberOfParallelCollectionsOptional = instance.numberOfParallelCollections()).isPresent()) {
                this.numberOfParallelCollections(numberOfParallelCollectionsOptional);
            }
            return this;
        }

        public final Builder verbose(boolean verbose) {
            this.verbose = verbose;
            this.optBits |= 1L;
            return this;
        }

        public final Builder databaseName(String databaseName) {
            this.databaseName = Objects.requireNonNull(databaseName, "databaseName");
            return this;
        }

        public final Builder databaseName(Optional<String> databaseName) {
            this.databaseName = databaseName.orElse(null);
            return this;
        }

        public final Builder collectionName(String collectionName) {
            this.collectionName = Objects.requireNonNull(collectionName, "collectionName");
            return this;
        }

        public final Builder collectionName(Optional<String> collectionName) {
            this.collectionName = collectionName.orElse(null);
            return this;
        }

        public final Builder query(String query) {
            this.query = Objects.requireNonNull(query, "query");
            return this;
        }

        public final Builder query(Optional<String> query) {
            this.query = query.orElse(null);
            return this;
        }

        public final Builder queryFile(String queryFile) {
            this.queryFile = Objects.requireNonNull(queryFile, "queryFile");
            return this;
        }

        public final Builder queryFile(Optional<String> queryFile) {
            this.queryFile = queryFile.orElse(null);
            return this;
        }

        public final Builder readPreference(String readPreference) {
            this.readPreference = Objects.requireNonNull(readPreference, "readPreference");
            return this;
        }

        public final Builder readPreference(Optional<String> readPreference) {
            this.readPreference = readPreference.orElse(null);
            return this;
        }

        public final Builder forceTableScan(boolean forceTableScan) {
            this.forceTableScan = forceTableScan;
            this.optBits |= 2L;
            return this;
        }

        public final Builder archive(String archive) {
            this.archive = Objects.requireNonNull(archive, "archive");
            return this;
        }

        public final Builder archive(Optional<String> archive) {
            this.archive = archive.orElse(null);
            return this;
        }

        public final Builder dumpDbUsersAndRoles(boolean dumpDbUsersAndRoles) {
            this.dumpDbUsersAndRoles = dumpDbUsersAndRoles;
            this.optBits |= 4L;
            return this;
        }

        public final Builder gzip(boolean gzip) {
            this.gzip = gzip;
            this.optBits |= 8L;
            return this;
        }

        public final Builder repair(boolean repair) {
            this.repair = repair;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder dir(String dir) {
            this.dir = Objects.requireNonNull(dir, "dir");
            return this;
        }

        public final Builder dir(Optional<String> dir) {
            this.dir = dir.orElse(null);
            return this;
        }

        public final Builder isOplog(boolean isOplog) {
            this.isOplog = isOplog;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder excludeCollection(String excludeCollection) {
            this.excludeCollection = Objects.requireNonNull(excludeCollection, "excludeCollection");
            return this;
        }

        public final Builder excludeCollection(Optional<String> excludeCollection) {
            this.excludeCollection = excludeCollection.orElse(null);
            return this;
        }

        public final Builder excludeCollectionWithPrefix(String excludeCollectionWithPrefix) {
            this.excludeCollectionWithPrefix = Objects.requireNonNull(excludeCollectionWithPrefix, "excludeCollectionWithPrefix");
            return this;
        }

        public final Builder excludeCollectionWithPrefix(Optional<String> excludeCollectionWithPrefix) {
            this.excludeCollectionWithPrefix = excludeCollectionWithPrefix.orElse(null);
            return this;
        }

        public final Builder numberOfParallelCollections(int numberOfParallelCollections) {
            this.numberOfParallelCollections = numberOfParallelCollections;
            return this;
        }

        public final Builder numberOfParallelCollections(OptionalInt numberOfParallelCollections) {
            this.numberOfParallelCollections = numberOfParallelCollections.isPresent() ? Integer.valueOf(numberOfParallelCollections.getAsInt()) : null;
            return this;
        }

        public ImmutableMongoDumpArguments build() {
            return new ImmutableMongoDumpArguments(this);
        }

        private boolean verboseIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean forceTableScanIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean dumpDbUsersAndRolesIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean gzipIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean repairIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean isOplogIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }
    }

    private final class InitShim {
        private byte verboseBuildStage = 0;
        private boolean verbose;
        private byte forceTableScanBuildStage = 0;
        private boolean forceTableScan;
        private byte dumpDbUsersAndRolesBuildStage = 0;
        private boolean dumpDbUsersAndRoles;
        private byte gzipBuildStage = 0;
        private boolean gzip;
        private byte repairBuildStage = 0;
        private boolean repair;
        private byte isOplogBuildStage = 0;
        private boolean isOplog;

        private InitShim() {
        }

        boolean verbose() {
            if (this.verboseBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.verboseBuildStage == 0) {
                this.verboseBuildStage = (byte)-1;
                this.verbose = ImmutableMongoDumpArguments.super.verbose();
                this.verboseBuildStage = 1;
            }
            return this.verbose;
        }

        void verbose(boolean verbose) {
            this.verbose = verbose;
            this.verboseBuildStage = 1;
        }

        boolean forceTableScan() {
            if (this.forceTableScanBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.forceTableScanBuildStage == 0) {
                this.forceTableScanBuildStage = (byte)-1;
                this.forceTableScan = ImmutableMongoDumpArguments.super.forceTableScan();
                this.forceTableScanBuildStage = 1;
            }
            return this.forceTableScan;
        }

        void forceTableScan(boolean forceTableScan) {
            this.forceTableScan = forceTableScan;
            this.forceTableScanBuildStage = 1;
        }

        boolean dumpDbUsersAndRoles() {
            if (this.dumpDbUsersAndRolesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.dumpDbUsersAndRolesBuildStage == 0) {
                this.dumpDbUsersAndRolesBuildStage = (byte)-1;
                this.dumpDbUsersAndRoles = ImmutableMongoDumpArguments.super.dumpDbUsersAndRoles();
                this.dumpDbUsersAndRolesBuildStage = 1;
            }
            return this.dumpDbUsersAndRoles;
        }

        void dumpDbUsersAndRoles(boolean dumpDbUsersAndRoles) {
            this.dumpDbUsersAndRoles = dumpDbUsersAndRoles;
            this.dumpDbUsersAndRolesBuildStage = 1;
        }

        boolean gzip() {
            if (this.gzipBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.gzipBuildStage == 0) {
                this.gzipBuildStage = (byte)-1;
                this.gzip = ImmutableMongoDumpArguments.super.gzip();
                this.gzipBuildStage = 1;
            }
            return this.gzip;
        }

        void gzip(boolean gzip) {
            this.gzip = gzip;
            this.gzipBuildStage = 1;
        }

        boolean repair() {
            if (this.repairBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.repairBuildStage == 0) {
                this.repairBuildStage = (byte)-1;
                this.repair = ImmutableMongoDumpArguments.super.repair();
                this.repairBuildStage = 1;
            }
            return this.repair;
        }

        void repair(boolean repair) {
            this.repair = repair;
            this.repairBuildStage = 1;
        }

        boolean isOplog() {
            if (this.isOplogBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isOplogBuildStage == 0) {
                this.isOplogBuildStage = (byte)-1;
                this.isOplog = ImmutableMongoDumpArguments.super.isOplog();
                this.isOplogBuildStage = 1;
            }
            return this.isOplog;
        }

        void isOplog(boolean isOplog) {
            this.isOplog = isOplog;
            this.isOplogBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.verboseBuildStage == -1) {
                attributes.add("verbose");
            }
            if (this.forceTableScanBuildStage == -1) {
                attributes.add("forceTableScan");
            }
            if (this.dumpDbUsersAndRolesBuildStage == -1) {
                attributes.add("dumpDbUsersAndRoles");
            }
            if (this.gzipBuildStage == -1) {
                attributes.add("gzip");
            }
            if (this.repairBuildStage == -1) {
                attributes.add("repair");
            }
            if (this.isOplogBuildStage == -1) {
                attributes.add("isOplog");
            }
            return "Cannot build MongoDumpArguments, attribute initializers form cycle " + attributes;
        }
    }
}

