/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.client;

import de.flapdoodle.embed.mongo.client.AuthenticationSetup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class ImmutableRole
implements AuthenticationSetup.Role {
    private final String database;
    private final String collection;
    private final String name;
    private final List<String> actions;

    private ImmutableRole(String database, String collection, String name) {
        this.database = Objects.requireNonNull(database, "database");
        this.collection = Objects.requireNonNull(collection, "collection");
        this.name = Objects.requireNonNull(name, "name");
        this.actions = Collections.emptyList();
    }

    private ImmutableRole(String database, String collection, String name, List<String> actions) {
        this.database = database;
        this.collection = collection;
        this.name = name;
        this.actions = actions;
    }

    @Override
    public String database() {
        return this.database;
    }

    @Override
    public String collection() {
        return this.collection;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public List<String> actions() {
        return this.actions;
    }

    public final ImmutableRole withDatabase(String value) {
        String newValue = Objects.requireNonNull(value, "database");
        if (this.database.equals(newValue)) {
            return this;
        }
        return new ImmutableRole(newValue, this.collection, this.name, this.actions);
    }

    public final ImmutableRole withCollection(String value) {
        String newValue = Objects.requireNonNull(value, "collection");
        if (this.collection.equals(newValue)) {
            return this;
        }
        return new ImmutableRole(this.database, newValue, this.name, this.actions);
    }

    public final ImmutableRole withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableRole(this.database, this.collection, newValue, this.actions);
    }

    public final ImmutableRole withActions(String ... elements) {
        List<String> newValue = ImmutableRole.createUnmodifiableList(false, ImmutableRole.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableRole(this.database, this.collection, this.name, newValue);
    }

    public final ImmutableRole withActions(Iterable<String> elements) {
        if (this.actions == elements) {
            return this;
        }
        List<String> newValue = ImmutableRole.createUnmodifiableList(false, ImmutableRole.createSafeList(elements, true, false));
        return new ImmutableRole(this.database, this.collection, this.name, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRole && this.equalsByValue((ImmutableRole)another);
    }

    private boolean equalsByValue(ImmutableRole another) {
        return this.database.equals(another.database) && this.collection.equals(another.collection) && this.name.equals(another.name) && this.actions.equals(another.actions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.database.hashCode();
        h += (h << 5) + this.collection.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.actions.hashCode();
        return h;
    }

    public String toString() {
        return "Role{database=" + this.database + ", collection=" + this.collection + ", name=" + this.name + ", actions=" + this.actions + "}";
    }

    public static ImmutableRole of(String database, String collection, String name) {
        return new ImmutableRole(database, collection, name);
    }

    public static ImmutableRole copyOf(AuthenticationSetup.Role instance) {
        if (instance instanceof ImmutableRole) {
            return (ImmutableRole)instance;
        }
        return ImmutableRole.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_DATABASE = 1L;
        private static final long INIT_BIT_COLLECTION = 2L;
        private static final long INIT_BIT_NAME = 4L;
        private long initBits = 7L;
        private String database;
        private String collection;
        private String name;
        private List<String> actions = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(AuthenticationSetup.Role instance) {
            Objects.requireNonNull(instance, "instance");
            this.database(instance.database());
            this.collection(instance.collection());
            this.name(instance.name());
            this.addAllActions(instance.actions());
            return this;
        }

        public final Builder database(String database) {
            this.database = Objects.requireNonNull(database, "database");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder collection(String collection) {
            this.collection = Objects.requireNonNull(collection, "collection");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder addActions(String element) {
            this.actions.add(Objects.requireNonNull(element, "actions element"));
            return this;
        }

        public final Builder addActions(String ... elements) {
            for (String element : elements) {
                this.actions.add(Objects.requireNonNull(element, "actions element"));
            }
            return this;
        }

        public final Builder actions(Iterable<String> elements) {
            this.actions.clear();
            return this.addAllActions(elements);
        }

        public final Builder addAllActions(Iterable<String> elements) {
            for (String element : elements) {
                this.actions.add(Objects.requireNonNull(element, "actions element"));
            }
            return this;
        }

        public ImmutableRole build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRole(this.database, this.collection, this.name, ImmutableRole.createUnmodifiableList(true, this.actions));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("database");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("collection");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build Role, some of required attributes are not set " + attributes;
        }
    }
}

