/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.transitions;

import de.flapdoodle.embed.mongo.commands.ServerAddress;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.runtime.Mongod;
import de.flapdoodle.embed.mongo.transitions.RunningMongodProcess;
import de.flapdoodle.embed.process.config.SupportConfig;
import de.flapdoodle.embed.process.io.ListeningStreamProcessor;
import de.flapdoodle.embed.process.io.Processors;
import de.flapdoodle.embed.process.io.ReaderProcessor;
import de.flapdoodle.embed.process.io.StreamProcessor;
import de.flapdoodle.embed.process.io.StreamToLineProcessor;
import de.flapdoodle.embed.process.io.SuccessMessageLineListener;
import de.flapdoodle.embed.process.runtime.ProcessControl;
import de.flapdoodle.embed.process.runtime.Processes;
import de.flapdoodle.embed.process.types.RunningProcessFactory;
import de.flapdoodle.embed.process.types.RunningProcessImpl;
import de.flapdoodle.os.Platform;
import de.flapdoodle.types.Try;
import java.io.Reader;
import java.net.InetAddress;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RunningMongoProcess
extends RunningProcessImpl {
    private static Logger LOGGER = LoggerFactory.getLogger(RunningMongodProcess.class);
    private final String commandName;
    private final SupportConfig supportConfig;
    private final Platform platform;
    private final StreamProcessor commandOutput;
    private final int mongoProcessId;
    private final InetAddress serverAddress;
    private final int port;
    private boolean shutDownCommandAlreadyExecuted = false;

    protected RunningMongoProcess(String commandName, ProcessControl process, Path pidFile, long timeout, Runnable onStop, SupportConfig supportConfig, Platform platform, Net net, StreamProcessor commandOutput, int mongoProcessId) {
        super(process, pidFile, timeout, onStop);
        this.commandName = commandName;
        this.supportConfig = supportConfig;
        this.platform = platform;
        this.commandOutput = commandOutput;
        this.mongoProcessId = mongoProcessId;
        this.serverAddress = (InetAddress)Try.get(net::getServerAddress);
        this.port = net.getPort();
    }

    public ServerAddress getServerAddress() {
        return ServerAddress.of(this.serverAddress, this.port);
    }

    public int stop() {
        try {
            this.stopInternal();
        }
        finally {
            return super.stop();
        }
    }

    private void stopInternal() {
        if (this.isAlive()) {
            LOGGER.debug("try to stop " + this.commandName);
            if (!this.shutDownCommandAlreadyExecuted && !this.sendStopToMongoInstance()) {
                LOGGER.warn("could not stop " + this.commandName + " with db command, try next");
                if (!this.sendKillToProcess()) {
                    LOGGER.warn("could not stop " + this.commandName + ", try next");
                    if (!this.sendTermToProcess()) {
                        LOGGER.warn("could not stop " + this.commandName + ", try next");
                        if (!this.tryKillToProcess()) {
                            LOGGER.warn("could not stop " + this.commandName + " the second time, try one last thing");
                        }
                    }
                }
            }
        }
    }

    private long getProcessId() {
        return this.mongoProcessId;
    }

    protected boolean sendKillToProcess() {
        return this.getProcessId() > 0L && Processes.killProcess((SupportConfig)this.supportConfig, (Platform)this.platform, (StreamProcessor)StreamToLineProcessor.wrap((StreamProcessor)this.commandOutput), (long)this.getProcessId());
    }

    protected boolean sendTermToProcess() {
        return this.getProcessId() > 0L && Processes.termProcess((SupportConfig)this.supportConfig, (Platform)this.platform, (StreamProcessor)StreamToLineProcessor.wrap((StreamProcessor)this.commandOutput), (long)this.getProcessId());
    }

    protected boolean tryKillToProcess() {
        return this.getProcessId() > 0L && Processes.tryKillProcess((SupportConfig)this.supportConfig, (Platform)this.platform, (StreamProcessor)StreamToLineProcessor.wrap((StreamProcessor)this.commandOutput), (long)this.getProcessId());
    }

    protected final boolean sendStopToMongoInstance() {
        return Mongod.sendShutdownLegacy(this.serverAddress, this.port) || Mongod.sendShutdown(this.serverAddress, this.port);
    }

    public void shutDownCommandAlreadyExecuted() {
        this.shutDownCommandAlreadyExecuted = true;
    }

    static <T extends RunningMongoProcess> RunningProcessFactory<T> factory(InstanceFactory<T> instanceFactory, long startupTimeout, SupportConfig supportConfig, Platform platform, Net net) {
        return (process, processOutput, pidFile, timeout) -> {
            LOGGER.trace("setup logWatch");
            SuccessMessageLineListener logWatch = RunningMongoProcess.errorMessageAwareLogWatch();
            LOGGER.trace("connect io");
            ReaderProcessor output = Processors.connect((Reader)process.getReader(), (StreamProcessor)new ListeningStreamProcessor(StreamToLineProcessor.wrap((StreamProcessor)processOutput.output()), arg_0 -> ((SuccessMessageLineListener)logWatch).inspect(arg_0)));
            ReaderProcessor error = Processors.connect((Reader)process.getError(), (StreamProcessor)new ListeningStreamProcessor(StreamToLineProcessor.wrap((StreamProcessor)processOutput.error()), arg_0 -> ((SuccessMessageLineListener)logWatch).inspect(arg_0)));
            Runnable closeAllOutputs = () -> {
                LOGGER.trace("ReaderProcessor.abortAll");
                ReaderProcessor.abortAll((ReaderProcessor[])new ReaderProcessor[]{output, error});
                LOGGER.trace("ReaderProcessor.abortAll done");
            };
            LOGGER.trace("waitForResult");
            logWatch.waitForResult(startupTimeout);
            LOGGER.trace("check if successMessageFound");
            if (logWatch.successMessageFound()) {
                LOGGER.trace("get processId");
                int pid = Mongod.getMongodProcessId(logWatch.allLines(), -1);
                LOGGER.trace("return RunningMongodProcess");
                return instanceFactory.create(process, pidFile, timeout, closeAllOutputs, supportConfig, platform, net, processOutput.commands(), pid);
            }
            String failureFound = logWatch.errorMessage().isPresent() ? (String)logWatch.errorMessage().get() : "\n----------------------\nHmm.. no failure or success message after " + startupTimeout + "ms .. \n...the cause must be somewhere in the process output:\n- 8<- - - - - - - - - -\n" + logWatch.allLines() + "\n- >8- - - - - - - - - -\n";
            return (RunningMongoProcess)((Object)((Object)Try.supplier(() -> {
                throw new RuntimeException("Could not start process: " + failureFound);
            }).andFinally(() -> process.stop(timeout)).andFinally(closeAllOutputs).get()));
        };
    }

    static SuccessMessageLineListener errorMessageAwareLogWatch() {
        return SuccessMessageLineListener.of(RunningMongoProcess.successMessage(), RunningMongoProcess.knownFailureMessages(), (String)"error");
    }

    private static List<String> successMessage() {
        return Arrays.asList("aiting for connections");
    }

    private static List<String> knownFailureMessages() {
        return Arrays.asList("(?<error>failed errno)", "ERROR:(?<error>.*)", "(?<error>error command line)", "(?<error>Error parsing command line:.*)", "(?<error>Address already in use)", "(?<error>error while loading shared libraries:.*)", "(?<error>SSLEAY32\\.dll was not found)", "(?<error>LIBEAY32\\.dll was not found)", "(?<error>the code execution cannot proceed because.*)", "(?<error>An attempt was made to access a socket in a way forbidden by its access permissions)");
    }

    static interface InstanceFactory<T extends RunningMongoProcess> {
        public T create(ProcessControl var1, Path var2, long var3, Runnable var5, SupportConfig var6, Platform var7, Net var8, StreamProcessor var9, int var10);
    }
}

