package de.flapdoodle.embed.mongo.types;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

/**
 * Immutable implementation of {@link _SystemEnv}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code SystemEnv.of()}.
 */
@SuppressWarnings({"all"})
public final class SystemEnv extends de.flapdoodle.embed.mongo.types._SystemEnv {
  private final Map<String, String> value;

  private SystemEnv(Map<String, ? extends String> value) {
    this.value = createUnmodifiableMap(true, false, value);
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public Map<String, String> value() {
    return value;
  }

  /**
   * This instance is equal to all instances of {@code SystemEnv} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof SystemEnv
        && equalTo(0, (SystemEnv) another);
  }

  private boolean equalTo(int synthetic, SystemEnv another) {
    return value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Construct a new immutable {@code SystemEnv} instance.
   * @param value The value for the {@code value} attribute
   * @return An immutable SystemEnv instance
   */
  public static SystemEnv of(Map<String, ? extends String> value) {
    return new SystemEnv(value);
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
