/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.client;

import de.flapdoodle.embed.mongo.client.AuthenticationSetup;
import de.flapdoodle.embed.mongo.client.UsernamePassword;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class ImmutableAuthenticationSetup
extends AuthenticationSetup {
    private final UsernamePassword admin;
    private final List<AuthenticationSetup.Entry> entries;

    private ImmutableAuthenticationSetup(UsernamePassword admin) {
        this.admin = Objects.requireNonNull(admin, "admin");
        this.entries = ImmutableAuthenticationSetup.createUnmodifiableList(false, ImmutableAuthenticationSetup.createSafeList(super.entries(), true, false));
    }

    private ImmutableAuthenticationSetup(Builder builder) {
        this.admin = builder.admin;
        this.entries = builder.entriesIsSet() ? ImmutableAuthenticationSetup.createUnmodifiableList(true, builder.entries) : ImmutableAuthenticationSetup.createUnmodifiableList(false, ImmutableAuthenticationSetup.createSafeList(super.entries(), true, false));
    }

    private ImmutableAuthenticationSetup(UsernamePassword admin, List<AuthenticationSetup.Entry> entries) {
        this.admin = admin;
        this.entries = entries;
    }

    @Override
    protected UsernamePassword admin() {
        return this.admin;
    }

    @Override
    protected List<AuthenticationSetup.Entry> entries() {
        return this.entries;
    }

    public final ImmutableAuthenticationSetup withAdmin(UsernamePassword value) {
        if (this.admin == value) {
            return this;
        }
        UsernamePassword newValue = Objects.requireNonNull(value, "admin");
        return new ImmutableAuthenticationSetup(newValue, this.entries);
    }

    public final ImmutableAuthenticationSetup withEntries(AuthenticationSetup.Entry ... elements) {
        List<AuthenticationSetup.Entry> newValue = ImmutableAuthenticationSetup.createUnmodifiableList(false, ImmutableAuthenticationSetup.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableAuthenticationSetup(this.admin, newValue);
    }

    public final ImmutableAuthenticationSetup withEntries(Iterable<? extends AuthenticationSetup.Entry> elements) {
        if (this.entries == elements) {
            return this;
        }
        List<AuthenticationSetup.Entry> newValue = ImmutableAuthenticationSetup.createUnmodifiableList(false, ImmutableAuthenticationSetup.createSafeList(elements, true, false));
        return new ImmutableAuthenticationSetup(this.admin, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAuthenticationSetup && this.equalTo(0, (ImmutableAuthenticationSetup)another);
    }

    private boolean equalTo(int synthetic, ImmutableAuthenticationSetup another) {
        return this.admin.equals(another.admin) && this.entries.equals(another.entries);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.admin.hashCode();
        h += (h << 5) + this.entries.hashCode();
        return h;
    }

    public String toString() {
        return "AuthenticationSetup{admin=" + this.admin + ", entries=" + this.entries + "}";
    }

    public static ImmutableAuthenticationSetup of(UsernamePassword admin) {
        return new ImmutableAuthenticationSetup(admin);
    }

    public static ImmutableAuthenticationSetup copyOf(AuthenticationSetup instance) {
        if (instance instanceof ImmutableAuthenticationSetup) {
            return (ImmutableAuthenticationSetup)instance;
        }
        return ImmutableAuthenticationSetup.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ADMIN = 1L;
        private static final long OPT_BIT_ENTRIES = 1L;
        private long initBits = 1L;
        private long optBits;
        private UsernamePassword admin;
        private List<AuthenticationSetup.Entry> entries = new ArrayList<AuthenticationSetup.Entry>();

        private Builder() {
        }

        public final Builder from(AuthenticationSetup instance) {
            Objects.requireNonNull(instance, "instance");
            this.admin(instance.admin());
            this.addAllEntries(instance.entries());
            return this;
        }

        public final Builder admin(UsernamePassword admin) {
            this.admin = Objects.requireNonNull(admin, "admin");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addEntries(AuthenticationSetup.Entry element) {
            this.entries.add(Objects.requireNonNull(element, "entries element"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder addEntries(AuthenticationSetup.Entry ... elements) {
            for (AuthenticationSetup.Entry element : elements) {
                this.entries.add(Objects.requireNonNull(element, "entries element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder entries(Iterable<? extends AuthenticationSetup.Entry> elements) {
            this.entries.clear();
            return this.addAllEntries(elements);
        }

        public final Builder addAllEntries(Iterable<? extends AuthenticationSetup.Entry> elements) {
            for (AuthenticationSetup.Entry entry : elements) {
                this.entries.add(Objects.requireNonNull(entry, "entries element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public ImmutableAuthenticationSetup build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAuthenticationSetup(this);
        }

        private boolean entriesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("admin");
            }
            return "Cannot build AuthenticationSetup, some of required attributes are not set " + attributes;
        }
    }
}

