/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.spring.autoconfigure;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import de.flapdoodle.embed.mongo.commands.ServerAddress;
import de.flapdoodle.embed.mongo.spring.autoconfigure.AbstractServerFactory;
import de.flapdoodle.embed.mongo.spring.autoconfigure.MongoClientAction;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;

public class SyncClientServerFactory
extends AbstractServerFactory<MongoClient> {
    private static Logger logger = LoggerFactory.getLogger(SyncClientServerFactory.class);

    SyncClientServerFactory(MongoProperties properties) {
        super(properties);
        logger.info("sync server factory");
    }

    @Override
    protected MongoClient client(ServerAddress serverAddress) {
        return MongoClients.create((String)("mongodb://" + serverAddress));
    }

    @Override
    protected MongoClient client(ServerAddress serverAddress, MongoCredential credential) {
        return MongoClients.create((MongoClientSettings)MongoClientSettings.builder().applyConnectionString(new ConnectionString("mongodb://" + serverAddress)).credential(credential).build());
    }

    @Override
    protected Document resultOfAction(MongoClient client, MongoClientAction.Action action) {
        if (action instanceof MongoClientAction.RunCommand) {
            return client.getDatabase(action.database()).runCommand((Bson)((MongoClientAction.RunCommand)action).command());
        }
        throw new IllegalArgumentException("Action not supported: " + action);
    }
}

