/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver;

import de.flapdoodle.embed.mongo.packageresolver.PlatformMatch;
import de.flapdoodle.os.BitSize;
import de.flapdoodle.os.CPUType;
import de.flapdoodle.os.OS;
import de.flapdoodle.os.Version;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class ImmutablePlatformMatch
implements PlatformMatch {
    private final Set<Version> version;
    private final CPUType cpuType;
    private final BitSize bitSize;
    private final OS os;

    private ImmutablePlatformMatch(Set<Version> version, CPUType cpuType, BitSize bitSize, OS os) {
        this.version = version;
        this.cpuType = cpuType;
        this.bitSize = bitSize;
        this.os = os;
    }

    @Override
    public Set<Version> version() {
        return this.version;
    }

    @Override
    public Optional<CPUType> cpuType() {
        return Optional.ofNullable(this.cpuType);
    }

    @Override
    public Optional<BitSize> bitSize() {
        return Optional.ofNullable(this.bitSize);
    }

    @Override
    public Optional<OS> os() {
        return Optional.ofNullable(this.os);
    }

    public final ImmutablePlatformMatch withVersion(Version ... elements) {
        Set<Version> newValue = ImmutablePlatformMatch.createUnmodifiableSet(ImmutablePlatformMatch.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePlatformMatch(newValue, this.cpuType, this.bitSize, this.os);
    }

    public final ImmutablePlatformMatch withVersion(Iterable<? extends Version> elements) {
        if (this.version == elements) {
            return this;
        }
        Set<Version> newValue = ImmutablePlatformMatch.createUnmodifiableSet(ImmutablePlatformMatch.createSafeList(elements, true, false));
        return new ImmutablePlatformMatch(newValue, this.cpuType, this.bitSize, this.os);
    }

    public final ImmutablePlatformMatch withCpuType(CPUType value) {
        CPUType newValue = Objects.requireNonNull(value, "cpuType");
        if (this.cpuType == newValue) {
            return this;
        }
        return new ImmutablePlatformMatch(this.version, newValue, this.bitSize, this.os);
    }

    public final ImmutablePlatformMatch withCpuType(Optional<? extends CPUType> optional) {
        CPUType value = optional.orElse(null);
        if (this.cpuType == value) {
            return this;
        }
        return new ImmutablePlatformMatch(this.version, value, this.bitSize, this.os);
    }

    public final ImmutablePlatformMatch withBitSize(BitSize value) {
        BitSize newValue = Objects.requireNonNull(value, "bitSize");
        if (this.bitSize == newValue) {
            return this;
        }
        return new ImmutablePlatformMatch(this.version, this.cpuType, newValue, this.os);
    }

    public final ImmutablePlatformMatch withBitSize(Optional<? extends BitSize> optional) {
        BitSize value = optional.orElse(null);
        if (this.bitSize == value) {
            return this;
        }
        return new ImmutablePlatformMatch(this.version, this.cpuType, value, this.os);
    }

    @Override
    public final ImmutablePlatformMatch withOs(OS value) {
        OS newValue = Objects.requireNonNull(value, "os");
        if (this.os == newValue) {
            return this;
        }
        return new ImmutablePlatformMatch(this.version, this.cpuType, this.bitSize, newValue);
    }

    public final ImmutablePlatformMatch withOs(Optional<? extends OS> optional) {
        OS value = optional.orElse(null);
        if (this.os == value) {
            return this;
        }
        return new ImmutablePlatformMatch(this.version, this.cpuType, this.bitSize, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePlatformMatch && this.equalTo(0, (ImmutablePlatformMatch)another);
    }

    private boolean equalTo(int synthetic, ImmutablePlatformMatch another) {
        return this.version.equals(another.version) && Objects.equals(this.cpuType, another.cpuType) && Objects.equals(this.bitSize, another.bitSize) && Objects.equals(this.os, another.os);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + Objects.hashCode(this.cpuType);
        h += (h << 5) + Objects.hashCode(this.bitSize);
        h += (h << 5) + Objects.hashCode(this.os);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("PlatformMatch{");
        builder.append("version=").append(this.version);
        if (this.cpuType != null) {
            builder.append(", ");
            builder.append("cpuType=").append(this.cpuType);
        }
        if (this.bitSize != null) {
            builder.append(", ");
            builder.append("bitSize=").append(this.bitSize);
        }
        if (this.os != null) {
            builder.append(", ");
            builder.append("os=").append(this.os);
        }
        return builder.append("}").toString();
    }

    public static ImmutablePlatformMatch copyOf(PlatformMatch instance) {
        if (instance instanceof ImmutablePlatformMatch) {
            return (ImmutablePlatformMatch)instance;
        }
        return ImmutablePlatformMatch.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size() * 4 / 3 + 1);
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    public static final class Builder {
        private List<Version> version = new ArrayList<Version>();
        private CPUType cpuType;
        private BitSize bitSize;
        private OS os;

        private Builder() {
        }

        public final Builder from(PlatformMatch instance) {
            Optional<OS> osOptional;
            Optional<BitSize> bitSizeOptional;
            Objects.requireNonNull(instance, "instance");
            this.addAllVersion(instance.version());
            Optional<CPUType> cpuTypeOptional = instance.cpuType();
            if (cpuTypeOptional.isPresent()) {
                this.cpuType(cpuTypeOptional);
            }
            if ((bitSizeOptional = instance.bitSize()).isPresent()) {
                this.bitSize(bitSizeOptional);
            }
            if ((osOptional = instance.os()).isPresent()) {
                this.os(osOptional);
            }
            return this;
        }

        public final Builder addVersion(Version element) {
            this.version.add(Objects.requireNonNull(element, "version element"));
            return this;
        }

        public final Builder addVersion(Version ... elements) {
            for (Version element : elements) {
                this.version.add(Objects.requireNonNull(element, "version element"));
            }
            return this;
        }

        public final Builder version(Iterable<? extends Version> elements) {
            this.version.clear();
            return this.addAllVersion(elements);
        }

        public final Builder addAllVersion(Iterable<? extends Version> elements) {
            for (Version version : elements) {
                this.version.add(Objects.requireNonNull(version, "version element"));
            }
            return this;
        }

        public final Builder cpuType(CPUType cpuType) {
            this.cpuType = Objects.requireNonNull(cpuType, "cpuType");
            return this;
        }

        public final Builder cpuType(Optional<? extends CPUType> cpuType) {
            this.cpuType = cpuType.orElse(null);
            return this;
        }

        public final Builder bitSize(BitSize bitSize) {
            this.bitSize = Objects.requireNonNull(bitSize, "bitSize");
            return this;
        }

        public final Builder bitSize(Optional<? extends BitSize> bitSize) {
            this.bitSize = bitSize.orElse(null);
            return this;
        }

        public final Builder os(OS os) {
            this.os = Objects.requireNonNull(os, "os");
            return this;
        }

        public final Builder os(Optional<? extends OS> os) {
            this.os = os.orElse(null);
            return this;
        }

        public ImmutablePlatformMatch build() {
            return new ImmutablePlatformMatch(ImmutablePlatformMatch.createUnmodifiableSet(this.version), this.cpuType, this.bitSize, this.os);
        }
    }
}

