/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.os.linux;

import de.flapdoodle.os.VersionWithPriority;
import de.flapdoodle.os.common.DistinctPeculiarity;
import de.flapdoodle.os.common.HasPecularities;
import de.flapdoodle.os.common.Peculiarity;
import de.flapdoodle.os.common.attributes.Attribute;
import de.flapdoodle.os.common.attributes.Attributes;
import de.flapdoodle.os.common.matcher.Matchers;
import java.util.List;

public enum AmazonVersion implements VersionWithPriority
{
    AmazonLinux(AmazonVersion.osVersionMatches(".*amzn1.*")),
    AmazonLinux2(AmazonVersion.osVersionMatches(".*amzn2.*"));

    private final List<Peculiarity> peculiarities;

    private AmazonVersion(Peculiarity ... peculiarities) {
        this.peculiarities = HasPecularities.asList(peculiarities);
    }

    @Override
    public List<Peculiarity> pecularities() {
        return this.peculiarities;
    }

    @Override
    public int priority() {
        return -1;
    }

    static DistinctPeculiarity<String> osVersionMatches(String name) {
        return DistinctPeculiarity.of(AmazonVersion.osVersion(), Matchers.matchPattern(name));
    }

    static Attribute<String> osVersion() {
        return Attributes.systemProperty("os.version");
    }
}

