/*
 * Decompiled with CFR 0.152.
 */
package de.fayard.refreshVersions.core.internal.problems;

import de.fayard.refreshVersions.core.internal.problems.Problem;
import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0000\u00a8\u0006\u0006"}, d2={"log", "", "Lorg/gradle/api/logging/Logger;", "problem", "Lde/fayard/refreshVersions/core/internal/problems/Problem;", "", "refreshVersions-core"})
public final class ProblemLoggingKt {
    public static final void log(@NotNull Logger $this$log, @NotNull Problem<? extends Object> problem) {
        char c;
        LogLevel logLevel;
        Intrinsics.checkNotNullParameter((Object)$this$log, (String)"$this$log");
        Intrinsics.checkNotNullParameter(problem, (String)"problem");
        Problem.Level level = problem.getLevel();
        if (Intrinsics.areEqual((Object)level, (Object)Problem.Level.Warning.INSTANCE)) {
            logLevel = LogLevel.WARN;
        } else if (Intrinsics.areEqual((Object)level, (Object)Problem.Level.Error.Companion)) {
            logLevel = LogLevel.ERROR;
        } else if (Intrinsics.areEqual((Object)level, (Object)Problem.Level.Error.Fatal.INSTANCE)) {
            logLevel = LogLevel.ERROR;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        LogLevel logLevel2 = logLevel;
        Problem.Level level2 = problem.getLevel();
        if (Intrinsics.areEqual((Object)level2, (Object)Problem.Level.Warning.INSTANCE)) {
            c = 'w';
        } else if (level2 instanceof Problem.Level.Error) {
            c = 'e';
        } else {
            throw new NoWhenBranchMatchedException();
        }
        char levelLetter = c;
        File affectedFile = problem.getAffectedFile();
        String message = problem.getErrorMessage();
        File file = affectedFile;
        if (file == null) {
            $this$log.log(logLevel2, message);
        } else {
            $this$log.log(logLevel2, levelLetter + ": " + affectedFile.getPath() + ":\n" + message);
        }
    }
}

