/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.gwt.gradle.task;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import de.esoco.gwt.gradle.command.CodeServerCommand;
import de.esoco.gwt.gradle.command.JettyServerCommand;
import de.esoco.gwt.gradle.extension.DevOption;
import de.esoco.gwt.gradle.extension.GwtExtension;
import de.esoco.gwt.gradle.task.AbstractTask;
import de.esoco.gwt.gradle.util.ResourceUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.gradle.api.Project;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.WarPluginConvention;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;

public class GwtDevTask
extends AbstractTask {
    public static final String NAME = "gwtDev";
    private final List<String> modules = Lists.newArrayList();
    private File jettyConf;

    public GwtDevTask() {
        this.setDescription("Run DevMode");
        this.dependsOn(new Object[]{"compileJava", "processResources"});
    }

    public void configureCodeServer(Project project, final GwtExtension extention) {
        DevOption options = extention.getDev();
        options.init(project);
        ConventionMapping convention = ((IConventionAware)this).getConventionMapping();
        convention.map("modules", (Callable)new Callable<List<String>>(){

            @Override
            public List<String> call() {
                return extention.getModule();
            }
        });
    }

    @TaskAction
    public void exec() throws Exception {
        GwtExtension extension = (GwtExtension)this.getProject().getExtensions().getByType(GwtExtension.class);
        DevOption sdmOption = extension.getDev();
        this.createWarExploded(sdmOption);
        ResourceUtils.ensureDir(sdmOption.getWar());
        ResourceUtils.ensureDir(sdmOption.getWorkDir());
        this.jettyConf = new File(this.getProject().getBuildDir(), "gwt/conf/jetty-run-conf.xml");
        ImmutableMap model = new ImmutableMap.Builder().put((Object)"__WAR_FILE__", (Object)sdmOption.getWar().getAbsolutePath()).build();
        ResourceUtils.copy("/stub.jetty-conf.xml", this.jettyConf, (Map<String, String>)model);
        Future<?> sdmTask = this.execSdm();
        if (!sdmTask.isDone()) {
            this.execJetty();
            sdmTask.cancel(true);
        }
    }

    @Input
    public List<String> getModules() {
        return this.modules;
    }

    private void createWarExploded(DevOption sdmOption) throws IOException {
        WarPluginConvention warConvention = (WarPluginConvention)this.getProject().getConvention().getPlugin(WarPluginConvention.class);
        JavaPluginConvention javaConvention = (JavaPluginConvention)this.getProject().getConvention().getPlugin(JavaPluginConvention.class);
        File warDir = sdmOption.getWar();
        ResourceUtils.copyDirectory(warConvention.getWebAppDir(), warDir);
        if (Boolean.TRUE.equals(sdmOption.getNoServer())) {
            File webInfDir = ResourceUtils.ensureDir(new File(warDir, "WEB-INF"));
            ResourceUtils.deleteDirectory(webInfDir);
        } else {
            SourceSet mainSourceSet = (SourceSet)javaConvention.getSourceSets().getByName("main");
            File classesDir = ResourceUtils.ensureDir(new File(warDir, "WEB-INF/classes"));
            for (File file : mainSourceSet.getResources().getSrcDirs()) {
                ResourceUtils.copyDirectory(file, classesDir);
            }
            for (File f : mainSourceSet.getOutput().getClassesDirs()) {
                ResourceUtils.copyDirectory(f, classesDir);
            }
            for (File file : mainSourceSet.getOutput().getFiles()) {
                if (!file.exists() || !file.isFile()) continue;
                ResourceUtils.copy(file, new File(classesDir, file.getName()));
            }
            File libDir = ResourceUtils.ensureDir(new File(warDir, "WEB-INF/lib"));
            for (File file : mainSourceSet.getRuntimeClasspath()) {
                if (!file.exists() || !file.isFile()) continue;
                ResourceUtils.copy(file, new File(libDir, file.getName()));
            }
        }
    }

    private JettyServerCommand execJetty() {
        GwtExtension extension = (GwtExtension)this.getProject().getExtensions().getByType(GwtExtension.class);
        JettyServerCommand command = new JettyServerCommand(this.getProject(), extension.getJetty(), this.jettyConf);
        command.execute();
        return command;
    }

    private Future<?> execSdm() {
        GwtExtension extension = (GwtExtension)this.getProject().getExtensions().getByType(GwtExtension.class);
        DevOption devOption = extension.getDev();
        if (!Strings.isNullOrEmpty((String)extension.getSourceLevel()) && Strings.isNullOrEmpty((String)devOption.getSourceLevel())) {
            devOption.setSourceLevel(extension.getSourceLevel());
        }
        CodeServerCommand command = new CodeServerCommand(this.getProject(), extension, this.getModules());
        FutureTask<Object> sdmTask = new FutureTask<Object>(() -> command.execute(), null);
        new Thread(sdmTask).start();
        return sdmTask;
    }
}

