/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.gwt.gradle.task;

import com.google.common.base.Strings;
import de.esoco.gwt.gradle.command.CodeServerCommand;
import de.esoco.gwt.gradle.extension.DevOption;
import de.esoco.gwt.gradle.extension.GwtExtension;
import de.esoco.gwt.gradle.task.AbstractTask;
import de.esoco.gwt.gradle.util.ResourceUtils;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;

public class GwtCodeServerTask
extends AbstractTask {
    public static final String NAME = "gwtCodeServer";

    public GwtCodeServerTask() {
        this.setDescription("Run CodeServer in SuperDevMode");
        this.dependsOn(new Object[]{"compileJava", "processResources"});
    }

    public void configureCodeServer(Project project, GwtExtension extention) {
        DevOption options = extention.getDev();
        options.init(project);
    }

    @TaskAction
    public void exec() {
        GwtExtension extension = (GwtExtension)this.getProject().getExtensions().getByType(GwtExtension.class);
        if (!Strings.isNullOrEmpty((String)extension.getSourceLevel()) && Strings.isNullOrEmpty((String)extension.getDev().getSourceLevel())) {
            extension.getDev().setSourceLevel(extension.getSourceLevel());
        }
        ResourceUtils.ensureDir(extension.getDev().getLauncherDir());
        CodeServerCommand command = new CodeServerCommand(this.getProject(), extension, extension.getModule());
        command.execute();
    }
}

