/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.gwt.gradle.task;

import de.esoco.gwt.gradle.command.CompileCommand;
import de.esoco.gwt.gradle.extension.CompilerOption;
import de.esoco.gwt.gradle.extension.GwtExtension;
import de.esoco.gwt.gradle.task.AbstractTask;
import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;

public class GwtCheckTask
extends AbstractTask {
    public static final String NAME = "gwtCheck";
    private List<String> modules;
    private FileCollection src;
    private File war;

    public GwtCheckTask() {
        this.setDescription("Check the GWT modules");
        this.dependsOn(new Object[]{"compileJava", "processResources"});
    }

    public void configure(Project project, final GwtExtension extention) {
        CompilerOption options = extention.getCompile();
        options.init(this.getProject());
        JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        SourceSet mainSourceSet = (SourceSet)javaConvention.getSourceSets().getByName("main");
        final FileCollection sources = this.getProject().files(new Object[]{project.files(new Object[]{mainSourceSet.getOutput().getResourcesDir()})}).plus((FileCollection)project.files(new Object[]{mainSourceSet.getOutput().getClassesDirs()})).plus((FileCollection)this.getProject().files(new Object[]{mainSourceSet.getAllSource().getSrcDirs()}));
        ConventionMapping mapping = ((IConventionAware)this).getConventionMapping();
        mapping.map("modules", (Callable)new Callable<List<String>>(){

            @Override
            public List<String> call() {
                return extention.getModule();
            }
        });
        mapping.map("war", (Callable)new Callable<File>(){

            @Override
            public File call() {
                return new File(GwtCheckTask.this.getProject().getBuildDir(), "out");
            }
        });
        mapping.map("src", (Callable)new Callable<FileCollection>(){

            @Override
            public FileCollection call() {
                return sources;
            }
        });
    }

    @TaskAction
    public void exec() {
        GwtExtension extension = (GwtExtension)this.getProject().getExtensions().getByType(GwtExtension.class);
        CompilerOption compilerOptions = extension.getCompile();
        CompileCommand command = new CompileCommand(this.getProject(), compilerOptions, this.getSrc(), null, this.getModules());
        command.addArg("-validateOnly");
        command.execute();
    }

    @Input
    public List<String> getModules() {
        return this.modules;
    }

    @InputFiles
    public FileCollection getSrc() {
        return this.src;
    }

    @OutputDirectory
    public File getWar() {
        return this.war;
    }
}

