/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.gwt.gradle.extension;

import com.google.common.collect.Lists;
import de.esoco.gwt.gradle.extension.CodeStyle;
import de.esoco.gwt.gradle.extension.JavaOption;
import de.esoco.gwt.gradle.extension.JsInteropMode;
import de.esoco.gwt.gradle.extension.LogLevel;
import de.esoco.gwt.gradle.extension.MethodNameDisplayMode;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.Project;

public class CompilerOption
extends JavaOption {
    private File workDir;
    private File war;
    private File deploy;
    private File gen;
    private File extra;
    private File saveSourceOutput;
    private File missingDepsFile;
    private LogLevel logLevel;
    private Boolean strict;
    private Boolean compileReport;
    private Boolean draftCompile;
    private Boolean checkAssertions;
    private CodeStyle style;
    private Integer optimize;
    private Boolean overlappingSourceWarnings;
    private Boolean saveSource;
    private Boolean failOnError;
    private String sourceLevel;
    private Integer localWorkers;
    private Integer localWorkersMem = 2048;
    private Boolean incremental;
    private MethodNameDisplayMode methodNameDisplayMode;
    private Boolean enforceStrictResources;
    private Boolean checkCasts;
    private Boolean classMetadata;
    private JsInteropMode jsInteropMode;
    private boolean generateJsInteropExports;
    private List<String> includeJsInteropExports;
    private List<String> excludeJsInteropExports;
    private final List<String> extraArgs = Lists.newArrayList();

    public Boolean getCheckAssertions() {
        return this.checkAssertions;
    }

    public Boolean getCheckCasts() {
        return this.checkCasts;
    }

    public Boolean getClassMetadata() {
        return this.classMetadata;
    }

    public Boolean getCompileReport() {
        return this.compileReport;
    }

    public File getDeploy() {
        return this.deploy;
    }

    public Boolean getDraftCompile() {
        return this.draftCompile;
    }

    public Boolean getEnforceStrictResources() {
        return this.enforceStrictResources;
    }

    public List<String> getExcludeJsInteropExports() {
        return this.excludeJsInteropExports;
    }

    public File getExtra() {
        return this.extra;
    }

    public List<String> getExtraArgs() {
        return this.extraArgs;
    }

    public Boolean getFailOnError() {
        return this.failOnError;
    }

    public File getGen() {
        return this.gen;
    }

    public boolean getGenerateJsInteropExports() {
        return this.generateJsInteropExports;
    }

    public List<String> getIncludeJsInteropExports() {
        return this.includeJsInteropExports;
    }

    public Boolean getIncremental() {
        return this.incremental;
    }

    public JsInteropMode getJsInteropMode() {
        return this.jsInteropMode;
    }

    public Integer getLocalWorkers() {
        return this.localWorkers;
    }

    public Integer getLocalWorkersMem() {
        return this.localWorkersMem;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public MethodNameDisplayMode getMethodNameDisplayMode() {
        return this.methodNameDisplayMode;
    }

    public File getMissingDepsFile() {
        return this.missingDepsFile;
    }

    public Integer getOptimize() {
        return this.optimize;
    }

    public Boolean getOverlappingSourceWarnings() {
        return this.overlappingSourceWarnings;
    }

    public Boolean getSaveSource() {
        return this.saveSource;
    }

    public File getSaveSourceOutput() {
        return this.saveSourceOutput;
    }

    public String getSourceLevel() {
        return this.sourceLevel;
    }

    public Boolean getStrict() {
        return this.strict;
    }

    public CodeStyle getStyle() {
        return this.style;
    }

    public File getWar() {
        return this.war;
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public void init(Project project) {
        File buildDir = new File(project.getBuildDir(), "gwt");
        this.war = new File(buildDir, "out");
        this.workDir = new File(buildDir, "work");
        this.gen = new File(buildDir, "extra/gen");
        this.deploy = new File(buildDir, "extra/deploy");
        this.extra = new File(buildDir, "extra");
        this.saveSourceOutput = new File(buildDir, "extra/source");
        this.missingDepsFile = new File(buildDir, "extra/missingDepsFile");
    }

    public void setCheckAssertions(Boolean checkAssertions) {
        this.checkAssertions = checkAssertions;
    }

    public void setCheckAssertions(String checkAssertions) {
        this.checkAssertions = Boolean.valueOf(checkAssertions);
    }

    public void setCheckCasts(Boolean checkCasts) {
        this.checkCasts = checkCasts;
    }

    public void setCheckCasts(String checkCasts) {
        this.checkCasts = Boolean.parseBoolean(checkCasts);
    }

    public void setClassMetadata(Boolean classMetadata) {
        this.classMetadata = classMetadata;
    }

    public void setClassMetadata(String classMetadata) {
        this.classMetadata = Boolean.parseBoolean(classMetadata);
    }

    public void setCompileReport(Boolean compileReport) {
        this.compileReport = compileReport;
    }

    public void setCompileReport(String compileReport) {
        this.compileReport = Boolean.parseBoolean(compileReport);
    }

    public void setDeploy(String deploy) {
        this.deploy = new File(deploy);
    }

    public void setDraftCompile(Boolean draftCompile) {
        this.draftCompile = draftCompile;
    }

    public void setDraftCompile(String draftCompile) {
        this.draftCompile = Boolean.parseBoolean(draftCompile);
    }

    public void setEnforceStrictResources(Boolean enforceStrictResources) {
        this.enforceStrictResources = enforceStrictResources;
    }

    public void setEnforceStrictResources(String enforceStrictResources) {
        this.enforceStrictResources = Boolean.parseBoolean(enforceStrictResources);
    }

    public void setExcludeJsInteropExports(String ... imports) {
        this.excludeJsInteropExports.addAll(Arrays.asList(imports));
    }

    public void setExtra(String extra) {
        this.extra = new File(extra);
    }

    public void setExtraArgs(String ... extraArgs) {
        this.extraArgs.addAll(Arrays.asList(extraArgs));
    }

    public void setFailOnError(Boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void setFailOnError(String failOnError) {
        this.failOnError = Boolean.parseBoolean(failOnError);
    }

    public void setGen(File gen) {
        this.gen = gen;
    }

    public void setGen(String gen) {
        this.gen = new File(gen);
    }

    public void setGenerateJsInteropExports(Boolean generateJsInteropExports) {
        this.generateJsInteropExports = generateJsInteropExports != null ? generateJsInteropExports : false;
    }

    public void setGenerateJsInteropExports(String generateJsInteropExports) {
        this.generateJsInteropExports = Boolean.parseBoolean(generateJsInteropExports);
    }

    public void setIncludeJsInteropExports(String ... imports) {
        this.includeJsInteropExports.addAll(Arrays.asList(imports));
    }

    public void setIncremental(Boolean incremental) {
        this.incremental = incremental;
    }

    public void setIncremental(String incremental) {
        this.incremental = Boolean.parseBoolean(incremental);
    }

    public void setJsInteropMode(String jsInteropMode) {
        this.jsInteropMode = JsInteropMode.valueOf(jsInteropMode);
    }

    public void setJsInteropMode(JsInteropMode jsInteropMode) {
        this.jsInteropMode = jsInteropMode;
    }

    public void setLocalWorkers(Integer localWorkers) {
        this.localWorkers = localWorkers;
    }

    public void setLocalWorkers(String localWorkers) {
        this.localWorkers = Integer.valueOf(localWorkers);
    }

    public void setLocalWorkersMem(Integer localWorkersMem) {
        this.localWorkersMem = localWorkersMem;
    }

    public void setLocalWorkersMem(String localWorkersMem) {
        this.localWorkersMem = Integer.valueOf(localWorkersMem);
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = LogLevel.valueOf(logLevel);
    }

    public void setMethodNameDisplayMode(MethodNameDisplayMode methodNameDisplayMode) {
        this.methodNameDisplayMode = methodNameDisplayMode;
    }

    public void setMethodNameDisplayMode(String methodNameDisplayMode) {
        this.methodNameDisplayMode = MethodNameDisplayMode.valueOf(methodNameDisplayMode);
    }

    public void setMissingDepsFile(String missingDepsFile) {
        this.missingDepsFile = new File(missingDepsFile);
    }

    public void setOptimize(Integer optimize) {
        this.optimize = optimize;
    }

    public void setOptimize(String optimize) {
        this.optimize = Integer.valueOf(optimize);
    }

    public void setOverlappingSourceWarnings(Boolean overlappingSourceWarnings) {
        this.overlappingSourceWarnings = overlappingSourceWarnings;
    }

    public void setSaveSource(Boolean saveSource) {
        this.saveSource = saveSource;
    }

    public void setSaveSource(String saveSource) {
        this.saveSource = Boolean.parseBoolean(saveSource);
    }

    public void setSaveSourceOutput(String saveSourceOutput) {
        this.saveSourceOutput = new File(saveSourceOutput);
    }

    public void setSourceLevel(String sourceLevel) {
        this.sourceLevel = sourceLevel;
    }

    public void setStrict(Boolean strict) {
        this.strict = strict;
    }

    public void setStrict(String strict) {
        this.strict = Boolean.valueOf(strict);
    }

    public void setStyle(CodeStyle style) {
        this.style = style;
    }

    public void setStyle(String style) {
        this.style = CodeStyle.valueOf(style);
    }

    public void setWar(String war) {
        this.war = new File(war);
    }

    public void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    public void setWorkDir(String workDir) {
        this.workDir = new File(workDir);
    }
}

