/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.gwt.gradle.command;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import de.esoco.gwt.gradle.GwtLibPlugin;
import de.esoco.gwt.gradle.extension.JavaOption;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.process.ExecResult;
import org.gradle.process.JavaExecSpec;

public abstract class AbstractCommand {
    private final List<String> javaArgs = Lists.newArrayList();
    private final List<String> args = Lists.newArrayList();
    private final List<String> classPaths = Lists.newArrayList();
    private final Project project;
    private final String mainClass;
    private JavaOption javaOptions;

    public AbstractCommand(Project project, String mainClass) {
        this.project = project;
        this.mainClass = mainClass;
        this.javaArgs.add("-Dfile.encoding=" + Charset.defaultCharset().name());
    }

    public AbstractCommand addArg(String argName) {
        if (!Strings.isNullOrEmpty((String)argName)) {
            this.args.add(argName);
        }
        return this;
    }

    public AbstractCommand addArg(String argName, File value) {
        if (value != null) {
            this.args.add(argName);
            this.args.add(value.getAbsolutePath());
        }
        return this;
    }

    public AbstractCommand addArg(String argName, Object value) {
        if (value != null) {
            this.args.add(argName);
            this.args.add(value.toString());
        }
        return this;
    }

    public AbstractCommand addArg(String argName, String value) {
        if (!Strings.isNullOrEmpty((String)value)) {
            this.args.add(argName);
            this.args.add(value);
        }
        return this;
    }

    public void addArgIf(Boolean condition, String argName) {
        if (Boolean.TRUE.equals(condition)) {
            this.addArg(argName);
        }
    }

    public void addArgIf(Boolean condition, String ifTrue, String ifFalse) {
        if (condition != null) {
            this.args.add(condition != false ? ifTrue : ifFalse);
        }
    }

    public AbstractCommand addClassPath(String classPath) {
        this.classPaths.add(classPath);
        return this;
    }

    public AbstractCommand addClassPath(Iterable<File> files) {
        for (File file : files) {
            if (file == null || !file.exists()) continue;
            this.addClassPath(file.getAbsolutePath());
        }
        return this;
    }

    public AbstractCommand addJavaArgs(String javaArg) {
        this.javaArgs.add(javaArg);
        return this;
    }

    public void configureJavaArgs(JavaOption javaOptions) {
        this.javaOptions = javaOptions;
        if (!Strings.isNullOrEmpty((String)javaOptions.getMaxPermSize())) {
            this.addJavaArgs("-XX:MaxPermSize=" + javaOptions.getMaxPermSize());
        }
        if (javaOptions.isDebugJava()) {
            String sb = "-agentlib:jdwp=server=y,transport=dt_socket,address=" + javaOptions.getDebugPort() + ",suspend=" + (javaOptions.isDebugSuspend() ? "y" : "n");
            this.addJavaArgs(sb);
        }
        for (String javaArg : javaOptions.getJavaArgs()) {
            this.addJavaArgs(javaArg);
        }
    }

    public void execute() {
        ExecResult execResult = this.project.javaexec((Action)new Action<JavaExecSpec>(){

            public void execute(JavaExecSpec spec) {
                ConfigurableFileCollection classpath = AbstractCommand.this.project.files(new Object[]{AbstractCommand.this.classPaths});
                spec.getMainClass().set((Object)AbstractCommand.this.mainClass);
                spec.setMinHeapSize(AbstractCommand.this.javaOptions.getMinHeapSize());
                spec.setMaxHeapSize(AbstractCommand.this.javaOptions.getMaxHeapSize());
                if (AbstractCommand.this.javaOptions.isEnvClasspath()) {
                    spec.environment("CLASSPATH", (Object)classpath.getAsPath());
                } else {
                    spec.setClasspath((FileCollection)classpath);
                }
                spec.jvmArgs((Iterable)AbstractCommand.this.javaArgs);
                spec.args((Iterable)AbstractCommand.this.args);
                if (AbstractCommand.this.javaOptions.getExecutable() != null) {
                    spec.setExecutable(AbstractCommand.this.javaOptions.getExecutable());
                }
            }
        });
        execResult.assertNormalExitValue().rethrowFailure();
    }

    protected Collection<File> getDependencySourceDirs(Project project) {
        ConfigurationContainer configs = project.getConfigurations();
        Configuration compileConf = configs.getByName("compileClasspath");
        DependencySet depSet = compileConf.getAllDependencies();
        ArrayList result = Lists.newArrayList();
        for (Dependency dep : depSet) {
            Project projectDependency;
            if (!(dep instanceof ProjectDependency) || !(projectDependency = ((ProjectDependency)dep).getDependencyProject()).getPlugins().hasPlugin(GwtLibPlugin.class)) continue;
            JavaPluginConvention javaConvention = (JavaPluginConvention)projectDependency.getConvention().getPlugin(JavaPluginConvention.class);
            SourceSet mainSourceSet = (SourceSet)javaConvention.getSourceSets().getByName("main");
            result.addAll(mainSourceSet.getAllSource().getSrcDirs());
        }
        return result;
    }
}

