/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.gwt.gradle.task;

import com.google.common.collect.ImmutableMap;
import de.esoco.gwt.gradle.command.JettyServerCommand;
import de.esoco.gwt.gradle.extension.GwtExtension;
import de.esoco.gwt.gradle.task.AbstractTask;
import de.esoco.gwt.gradle.util.ResourceUtils;
import java.io.File;
import java.util.Map;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.bundling.War;

public class GwtRunTask
extends AbstractTask {
    public static final String NAME = "gwtRun";
    private File jettyConf;

    public GwtRunTask() {
        this.setDescription("Run jetty with the GW the GWT modules");
        this.dependsOn(new Object[]{"war"});
    }

    @TaskAction
    public void exec() throws Exception {
        War warTask = (War)this.getProject().getTasks().getByName("war");
        this.jettyConf = new File(this.getProject().getBuildDir(), "gwt/conf/jetty-run-conf.xml");
        ImmutableMap model = new ImmutableMap.Builder().put((Object)"__WAR_FILE__", (Object)warTask.getArchivePath().getAbsolutePath()).build();
        ResourceUtils.copy("/stub.jetty-conf.xml", this.jettyConf, (Map<String, String>)model);
        GwtExtension extension = (GwtExtension)this.getProject().getExtensions().getByType(GwtExtension.class);
        JettyServerCommand command = new JettyServerCommand(this.getProject(), extension.getJetty(), this.jettyConf);
        command.execute();
    }
}

