/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.gwt.gradle.task;

import com.google.common.base.Strings;
import com.sun.management.OperatingSystemMXBean;
import de.esoco.gwt.gradle.command.CompileCommand;
import de.esoco.gwt.gradle.extension.CompilerOption;
import de.esoco.gwt.gradle.extension.GwtExtension;
import de.esoco.gwt.gradle.task.AbstractTask;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class GwtCompileTask
extends AbstractTask {
    public static final String NAME = "gwtCompile";
    private List<String> modules;
    private File war;
    private FileCollection src;

    public GwtCompileTask() {
        this.setDescription("Compile the GWT modules");
        this.dependsOn(new Object[]{"compileJava", "processResources"});
    }

    public void configure(Project project, final GwtExtension extension) {
        final CompilerOption options = extension.getCompile();
        options.init(project);
        options.setLocalWorkers(this.evalWorkers(options));
        final ConfigurableFileCollection sources = project.files(new Object[0]);
        HashSet<Project> allProjects = new HashSet<Project>();
        this.addSources(project, sources, allProjects);
        ConventionMapping mapping = ((IConventionAware)this).getConventionMapping();
        mapping.map("modules", (Callable)new Callable<List<String>>(){

            @Override
            public List<String> call() {
                return extension.getModule();
            }
        });
        mapping.map("war", (Callable)new Callable<File>(){

            @Override
            public File call() {
                return options.getWar();
            }
        });
        mapping.map("src", (Callable)new Callable<FileCollection>(){

            @Override
            public FileCollection call() {
                return sources;
            }
        });
    }

    @TaskAction
    public void exec() {
        Project project = this.getProject();
        GwtExtension extension = (GwtExtension)project.getExtensions().getByType(GwtExtension.class);
        CompilerOption compilerOptions = extension.getCompile();
        if (!Strings.isNullOrEmpty((String)extension.getSourceLevel()) && Strings.isNullOrEmpty((String)compilerOptions.getSourceLevel())) {
            compilerOptions.setSourceLevel(extension.getSourceLevel());
        }
        CompileCommand command = new CompileCommand(project, compilerOptions, this.getSrc(), this.getWar(), this.getModules());
        command.execute();
        project.getTasks().getByName("gwtCheck").setEnabled(false);
    }

    @Input
    public List<String> getModules() {
        return this.modules;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getSrc() {
        return this.src;
    }

    @OutputDirectory
    public File getWar() {
        return this.war;
    }

    private void addSources(Project project, final ConfigurableFileCollection sources, final Set<Project> allProjects) {
        if (allProjects.add(project)) {
            Action<Project> includeSourceAction = new Action<Project>(){

                public void execute(Project project) {
                    GwtCompileTask.this.addSourceSet(sources, project, allProjects, "main");
                }
            };
            if (project.getState().getExecuted()) {
                includeSourceAction.execute((Object)project);
            } else {
                project.afterEvaluate((Action)includeSourceAction);
            }
        }
    }

    private void addSourceSet(ConfigurableFileCollection sources, Project project, Set<Project> allProjects, String sourceSet) {
        JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().findPlugin(JavaPluginConvention.class);
        if (javaConvention != null) {
            project.getLogger().info("Adding {}.sourceSets.main.output and sourceSets.main.allSource.srcDirs to {}", (Object)project.getPath(), (Object)this.getPath());
            SourceSet mainSourceSet = (SourceSet)javaConvention.getSourceSets().getByName(sourceSet);
            sources.from(new Object[]{project.files(new Object[]{mainSourceSet.getOutput()})}).from(new Object[]{project.files(new Object[]{mainSourceSet.getAllSource().getSrcDirs()})});
            Configuration config = project.getConfigurations().getByName(mainSourceSet.getCompileClasspathConfigurationName());
            for (Dependency dep : config.getAllDependencies()) {
                if (!(dep instanceof ProjectDependency)) continue;
                this.addSources(((ProjectDependency)dep).getDependencyProject(), sources, allProjects);
            }
        }
    }

    private int evalWorkers(CompilerOption options) {
        long workers = Runtime.getRuntime().availableProcessors();
        java.lang.management.OperatingSystemMXBean osMBean = ManagementFactory.getOperatingSystemMXBean();
        if (osMBean instanceof OperatingSystemMXBean) {
            OperatingSystemMXBean sunOsMBean = (OperatingSystemMXBean)osMBean;
            long memPerWorker = 0x100000L * (long)options.getLocalWorkersMem().intValue();
            long nbFreeMemInGb = sunOsMBean.getFreePhysicalMemorySize() / memPerWorker;
            if (nbFreeMemInGb < workers) {
                workers = nbFreeMemInGb;
            }
            if (workers < 1L) {
                workers = 1L;
            }
        }
        return (int)workers;
    }
}

