/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.gwt.gradle.command;

import de.esoco.gwt.gradle.command.AbstractCommand;
import de.esoco.gwt.gradle.extension.JettyOption;
import de.esoco.gwt.gradle.util.ResourceUtils;
import java.io.File;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;

public class JettyServerCommand
extends AbstractCommand {
    public JettyServerCommand(Project project, JettyOption jettyOption, File jettyConf) {
        super(project, "org.eclipse.jetty.runner.Runner");
        this.configure(project, jettyOption, jettyConf);
    }

    private void configure(Project project, JettyOption jettyOption, File jettyConf) {
        ConfigurationContainer configs = project.getConfigurations();
        Configuration runtimeConf = configs.getByName("providedRuntime");
        Configuration jettyClassPath = configs.getByName("jettyConf");
        this.configureJavaArgs(jettyOption);
        this.addClassPath(jettyClassPath.getAsPath());
        this.addClassPath(runtimeConf.getAsPath());
        if (jettyOption.getLogRequestFile() != null) {
            ResourceUtils.ensureDir(jettyOption.getLogRequestFile().getParentFile());
            this.addArg("--log", jettyOption.getLogRequestFile());
        }
        if (jettyOption.getLogFile() != null) {
            ResourceUtils.ensureDir(jettyOption.getLogFile().getParentFile());
            this.addArg("--out", jettyOption.getLogFile());
        }
        this.addArg("--host", jettyOption.getBindAddress());
        this.addArg("--port", jettyOption.getPort());
        this.addArg("--stop-port", jettyOption.getStopPort());
        this.addArg("--stop-key", jettyOption.getStopKey());
        this.addArg(jettyConf.getAbsolutePath());
    }
}

