/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.gwt.gradle.command;

import de.esoco.gwt.gradle.command.AbstractCommand;
import de.esoco.gwt.gradle.extension.DevOption;
import de.esoco.gwt.gradle.extension.GwtExtension;
import de.esoco.gwt.gradle.util.ResourceUtils;
import java.io.File;
import java.util.Collection;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;

public class CodeServerCommand
extends AbstractCommand {
    public CodeServerCommand(Project project, GwtExtension extension, Collection<String> modules) {
        super(project, "com.google.gwt.dev.codeserver.CodeServer");
        this.configure(project, extension, modules);
    }

    public void configure(Project project, GwtExtension extension, Collection<String> modules) {
        DevOption devOption = extension.getDev();
        if (extension.getGwtVersion().startsWith("2.6")) {
            this.addArg("-launcherDir", devOption.getLauncherDir());
        }
        ConfigurationContainer configs = project.getConfigurations();
        Configuration sdmConf = configs.getByName("gwtSdk");
        SourceSet mainSourceSet = (SourceSet)((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().getByName("main");
        ConfigurableFileCollection sources = project.files(new Object[]{mainSourceSet.getAllJava().getSrcDirs()});
        this.configureJavaArgs(devOption);
        this.addClassPath(mainSourceSet.getOutput().getAsPath());
        this.addClassPath(mainSourceSet.getAllJava().getSrcDirs());
        this.addClassPath(mainSourceSet.getCompileClasspath().getAsPath());
        this.addClassPath(sdmConf.getAsPath());
        this.addSrc((Iterable<File>)sources);
        this.addSrc(this.getDependencySourceDirs(project));
        this.addArg("-bindAddress", devOption.getBindAddress());
        this.addArgIf(devOption.getFailOnError(), "-failOnError", "-nofailOnError");
        this.addArgIf(devOption.getPrecompile(), "-precompile", "-noprecompile");
        this.addArg("-port", devOption.getPort());
        this.addArgIf(devOption.getStrict(), "-strict");
        this.addArgIf(devOption.getEnforceStrictResources(), "-XenforceStrictResources ", "-XnoenforceStrictResources");
        this.addArg("-workDir", ResourceUtils.ensureDir(devOption.getWorkDir()));
        this.addArgIf(devOption.getIncremental(), "-incremental", "-noincremental");
        this.addArg("-sourceLevel", devOption.getSourceLevel());
        if (!extension.getGwtVersion().startsWith("2.6")) {
            this.addArg("-logLevel", (Object)devOption.getLogLevel());
        }
        this.addArg("-XmethodNameDisplayMode", (Object)devOption.getMethodNameDisplayMode());
        this.addArg("-XjsInteropMode", (Object)devOption.getJsInteropMode());
        this.addArgIf(devOption.getGenerateJsInteropExports(), "-generateJsInteropExports");
        if (devOption.getExtraArgs() != null) {
            for (String arg : devOption.getExtraArgs()) {
                if (arg == null || arg.length() <= 0) continue;
                this.addArg(arg);
            }
        }
        for (String module : modules) {
            this.addArg(module);
        }
    }

    private void addSrc(Iterable<File> sources) {
        for (File srcDir : sources) {
            if (!srcDir.isDirectory()) continue;
            this.addArg("-src", srcDir);
        }
    }
}

