/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.gwt.gradle;

import de.esoco.gwt.gradle.GwtLibPlugin;
import de.esoco.gwt.gradle.extension.GwtExtension;
import de.esoco.gwt.gradle.task.GwtCheckTask;
import de.esoco.gwt.gradle.task.GwtCodeServerTask;
import de.esoco.gwt.gradle.task.GwtCompileTask;
import de.esoco.gwt.gradle.task.GwtDevTask;
import de.esoco.gwt.gradle.task.GwtRunTask;
import de.esoco.gwt.gradle.task.GwtStopTask;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.tasks.bundling.War;

public class GwtPlugin
implements Plugin<Project> {
    private static final Logger LOGGER = Logging.getLogger(GwtPlugin.class);

    public void apply(Project project) {
        LOGGER.debug("apply gwt plugin");
        project.getPlugins().apply(GwtLibPlugin.class);
        project.getPlugins().apply(WarPlugin.class);
        this.createCheckTask(project);
        this.createCompileTask(project);
        this.createCodeServerTask(project);
        this.createDevTask(project);
        this.createRunTask(project);
        this.createStopTask(project);
    }

    private void createStopTask(Project project) {
        project.getTasks().create("gwtStop", GwtStopTask.class);
    }

    private void createCheckTask(final Project project) {
        project.getTasks().create("gwtCheck", GwtCheckTask.class);
        final GwtExtension extension = (GwtExtension)project.getExtensions().getByType(GwtExtension.class);
        Task checkTask = project.getTasks().getByName("check");
        checkTask.dependsOn(new Object[]{"gwtCheck"});
        project.getTasks().withType(GwtCheckTask.class, (Action)new Action<GwtCheckTask>(){

            public void execute(GwtCheckTask task) {
                task.configure(project, extension);
            }
        });
    }

    private void createCompileTask(final Project project) {
        project.getTasks().create("gwtCompile", GwtCompileTask.class);
        final GwtExtension extension = (GwtExtension)project.getExtensions().getByType(GwtExtension.class);
        final War warTask = (War)project.getTasks().withType(War.class).getByName("war");
        warTask.dependsOn(new Object[]{"gwtCompile"});
        project.getTasks().withType(GwtCompileTask.class, (Action)new Action<GwtCompileTask>(){

            public void execute(GwtCompileTask task) {
                task.configure(project, extension);
                warTask.from(new Object[]{extension.getCompile().getWar()});
            }
        });
    }

    private void createRunTask(Project project) {
        project.getTasks().create("gwtRun", GwtRunTask.class);
    }

    private void createCodeServerTask(final Project project) {
        project.getTasks().create("gwtCodeServer", GwtCodeServerTask.class);
        final GwtExtension extension = (GwtExtension)project.getExtensions().getByType(GwtExtension.class);
        project.getTasks().withType(GwtCodeServerTask.class, (Action)new Action<GwtCodeServerTask>(){

            public void execute(GwtCodeServerTask task) {
                task.configureCodeServer(project, extension);
            }
        });
    }

    private void createDevTask(final Project project) {
        project.getTasks().create("gwtDev", GwtDevTask.class);
        final GwtExtension extension = (GwtExtension)project.getExtensions().getByType(GwtExtension.class);
        project.getTasks().withType(GwtDevTask.class, (Action)new Action<GwtDevTask>(){

            public void execute(GwtDevTask task) {
                task.configureCodeServer(project, extension);
            }
        });
    }
}

